/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.config;

import java.io.File;
import java.io.IOException;
import net.jangaroo.exml.config.ValidationMode;
import net.jangaroo.exml.utils.ExmlUtils;
import net.jangaroo.jooc.api.CompileLog;
import net.jangaroo.utils.CompilerUtils;
import net.jangaroo.utils.FileLocations;
import org.kohsuke.args4j.Option;

public class ExmlConfiguration
extends FileLocations {
    private String configClassPackage;
    private File resourceOutputDirectory;
    private ValidationMode validationMode = ValidationMode.OFF;
    private CompileLog log;

    public String getConfigClassPackage() {
        return this.configClassPackage;
    }

    @Option(name="-c", aliases={"--config-package"}, metaVar="NAME", usage="Name of the config class package", required=true)
    public void setConfigClassPackage(String configClassPackage) {
        this.configClassPackage = configClassPackage;
    }

    public File getResourceOutputDirectory() {
        return this.resourceOutputDirectory;
    }

    @Option(name="-r", metaVar="RES_DIR", usage="output directory for generated xsd files, default is DEST_DIR")
    public void setResourceOutputDirectory(File resourceOutputDirectory) {
        this.resourceOutputDirectory = resourceOutputDirectory;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }

    @Option(name="-vm", aliases={"--validation-mode"}, usage="Severity of EXML validation errors: error, warn, off (no validation)")
    public void setValidationMode(ValidationMode validationMode) {
        this.validationMode = validationMode;
    }

    public void setLog(CompileLog log) {
        this.log = log;
    }

    public CompileLog getLog() {
        return this.log;
    }

    public File computeConfigClassTarget(String configClassName) {
        return CompilerUtils.fileFromQName(this.getConfigClassPackage(), configClassName, this.getOutputDirectory(), ".as");
    }

    public File computeGeneratedConfigClassFile(File exmlFile) {
        return this.computeConfigClassTarget(CompilerUtils.uncapitalize(CompilerUtils.removeExtension(exmlFile.getName())));
    }

    public File computeGeneratedComponentClassFile(File exmlFile) throws IOException {
        File sourceDir = this.findSourceDir(exmlFile);
        String qName = CompilerUtils.qNameFromFile(sourceDir, exmlFile);
        String className = ExmlUtils.createComponentClassName(CompilerUtils.className(qName));
        String packageName = CompilerUtils.packageName(qName);
        File classFile = CompilerUtils.fileFromQName(packageName, className, sourceDir, ".as");
        return classFile.exists() ? null : CompilerUtils.fileFromQName(packageName, className, this.getOutputDirectory(), ".as");
    }

    @Override
    public String toString() {
        return "ExmlConfiguration{configClassPackage='" + this.configClassPackage + '\'' + '}' + super.toString();
    }
}

