/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.generator;

import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import net.jangaroo.exml.api.ExmlcException;
import net.jangaroo.exml.model.ConfigClass;

public final class ExmlConfigClassGenerator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateClass(ConfigClass configClass, File result) throws IOException, TemplateException {
        File targetPackageFolder = result.getAbsoluteFile().getParentFile();
        if (!targetPackageFolder.exists()) {
            targetPackageFolder.mkdirs();
        }
        Writer writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(result), "UTF-8");
            ExmlConfigClassGenerator.generateClass(configClass, writer);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private static void generateClass(ConfigClass configClass, Writer output) throws IOException, TemplateException {
        if (configClass.getSuperClassName() == null) {
            throw new ExmlcException("Config class " + configClass.getFullName() + "'s super class name is null!");
        }
        Configuration cfg = new Configuration();
        cfg.setClassForTemplateLoading(ConfigClass.class, "/");
        cfg.setObjectWrapper(new DefaultObjectWrapper());
        Template template = cfg.getTemplate("/net/jangaroo/exml/templates/exml_config_class.ftl");
        Environment env = template.createProcessingEnvironment(configClass, output);
        env.setOutputEncoding("UTF-8");
        env.process();
    }

    public boolean mustGenerateConfigClass(File source, File targetFile) {
        return !targetFile.exists() || targetFile.lastModified() < source.lastModified();
    }
}

