/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jangaroo.exml.model.ConfigClass;
import net.jangaroo.exml.model.ConfigClassToNewExmlElementAdapter;
import net.jangaroo.exml.model.ConfigClassToOldExmlElementAdapter;
import net.jangaroo.exml.model.ExmlElement;

public class ExmlConfigPackage {
    private static final Comparator<ExmlElement> EXML_ELEMENT_BY_NAME_COMPARATOR = new Comparator<ExmlElement>(){

        @Override
        public int compare(ExmlElement ee1, ExmlElement ee2) {
            return ee1.getName().compareTo(ee2.getName());
        }
    };
    private List<ExmlElement> exmlElements;
    private Map<String, String> usedNamespaces;
    private String packageName;
    private String ns;

    public ExmlConfigPackage(Collection<ConfigClass> cl, String packageName) {
        this.packageName = packageName;
        this.ns = this.calcNsFromPackageName(packageName, 1);
        this.exmlElements = new ArrayList<ExmlElement>(cl.size());
        boolean useTargetClassNames = !packageName.endsWith(".config");
        for (ConfigClass configClass : cl) {
            this.exmlElements.add(useTargetClassNames ? new ConfigClassToNewExmlElementAdapter(configClass) : new ConfigClassToOldExmlElementAdapter(configClass));
        }
        this.computeShortNamespaces();
        Collections.sort(this.exmlElements, EXML_ELEMENT_BY_NAME_COMPARATOR);
    }

    private void computeShortNamespaces() {
        this.usedNamespaces = new HashMap<String, String>();
        for (ExmlElement ee : this.exmlElements) {
            this.calcNsFromPackage(ee);
            ExmlElement superElement = ee.getSuperElement();
            if (superElement == null) continue;
            this.calcNsFromPackage(superElement);
        }
    }

    private void calcNsFromPackage(ExmlElement exmlElement) {
        String shortNamespace;
        String packageName = exmlElement.getPackage();
        if (this.packageName.equals(packageName)) {
            shortNamespace = this.ns;
        } else {
            shortNamespace = this.usedNamespaces.get(packageName);
            if (shortNamespace == null) {
                if (packageName.length() == 0) {
                    shortNamespace = "top";
                } else {
                    int n = 1;
                    while (true) {
                        shortNamespace = this.calcNsFromPackageName(packageName, n);
                        if (!this.usedNamespaces.values().contains(shortNamespace)) break;
                        ++n;
                    }
                }
                this.usedNamespaces.put(packageName, shortNamespace);
            }
        }
        exmlElement.setNs(shortNamespace);
    }

    private String calcNsFromPackageName(String packageName, int n) {
        if (packageName.length() == 0) {
            return "t";
        }
        String[] parts = packageName.split("\\.");
        StringBuilder ns = new StringBuilder();
        for (String part : parts) {
            ns.append(part.substring(0, n));
        }
        String shortNamespace = ns.toString();
        return shortNamespace;
    }

    public String getNs() {
        return this.ns;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public List<ExmlElement> getExmlElements() {
        return this.exmlElements;
    }

    public Map<String, String> getUsedNamespaces() {
        return this.usedNamespaces;
    }
}

