/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.model;

import java.util.List;
import net.jangaroo.exml.model.ConfigAttribute;
import net.jangaroo.exml.model.ConfigClass;
import net.jangaroo.exml.model.ExmlElement;

public abstract class AbstractConfigClassToExmlElementAdapter
implements ExmlElement {
    protected ConfigClass configClass;
    private String ns;
    private ExmlElement superElement;

    public AbstractConfigClassToExmlElementAdapter(ConfigClass configClass) {
        this.configClass = configClass;
    }

    @Override
    public String getNamespace() {
        return "exml:" + this.getPackage();
    }

    @Override
    public void setNs(String shortNamespace) {
        this.ns = shortNamespace;
    }

    @Override
    public String getNs() {
        return this.ns;
    }

    @Override
    public abstract String getTypeName();

    @Override
    public String getFullTypeName() {
        return this.getNs() + ":" + this.getTypeName();
    }

    @Override
    public String getDescription() {
        return this.configClass.getDescription();
    }

    @Override
    public List<ConfigAttribute> getDirectCfgs() {
        return this.configClass.getDirectCfgs();
    }

    @Override
    public ExmlElement getSuperElement() {
        if (this.superElement == null) {
            if (this.configClass.getSuperClass() == null) {
                return null;
            }
            this.superElement = this.createAdapter(this.configClass.getSuperClass());
        }
        return this.superElement;
    }

    protected abstract ExmlElement createAdapter(ConfigClass var1);

    public String toString() {
        return "<" + this.getNamespace() + ":" + this.getName() + ">";
    }
}

