/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jangaroo.utils.BOMStripperInputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.plexus.archiver.zip.ZipEntry;
import org.codehaus.plexus.archiver.zip.ZipFile;
import org.codehaus.plexus.util.IOUtil;

public abstract class PackageApplicationMojo
extends AbstractMojo {
    protected MavenProject project;
    private MavenProjectBuilder mavenProjectBuilder;
    private ArtifactRepository localRepository;
    private List remoteRepositories;
    private static final Pattern LOAD_SCRIPT_CODE_PATTERN = Pattern.compile("\\s*joo\\.loadScript\\(['\"]([^'\"]+)['\"]\\s*[,)].*");
    private static final Pattern LOAD_MODULE_CODE_PATTERN = Pattern.compile("\\s*joo\\.loadModule\\(['\"]([^'\"]+)['\"]\\s*,\\s*['\"]([^'\"]+)['\"].*");

    public abstract File getPackageSourceDirectory();

    protected void createWebapp(File webappDirectory) throws MojoExecutionException {
        if (webappDirectory.mkdirs()) {
            this.getLog().debug((CharSequence)("created webapp directory " + webappDirectory));
        }
        try {
            this.concatModuleScripts(new File(webappDirectory, "joo"));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create jangaroo-application[-all].js", (Exception)e);
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException("Failed to create jangaroo-application[-all].js", (Exception)((Object)e));
        }
    }

    public static List<String> sort(Map<String, List<String>> artifact2directDependencies) {
        LinkedList<String> alreadyOut = new LinkedList<String>();
        while (!artifact2directDependencies.isEmpty()) {
            String currentDep = PackageApplicationMojo.goDeep(artifact2directDependencies.keySet().iterator().next(), artifact2directDependencies);
            PackageApplicationMojo.removeAll(currentDep, artifact2directDependencies);
            alreadyOut.add(currentDep);
        }
        return alreadyOut;
    }

    private static String goDeep(String start, Map<String, List<String>> artifact2directDependencies) {
        while (artifact2directDependencies.get(start) != null && !artifact2directDependencies.get(start).isEmpty()) {
            start = artifact2directDependencies.get(start).iterator().next();
        }
        return start;
    }

    private static void removeAll(String toBeRemoved, Map<String, List<String>> artifact2directDependencies) {
        artifact2directDependencies.remove(toBeRemoved);
        for (List<String> strings : artifact2directDependencies.values()) {
            strings.remove(toBeRemoved);
        }
    }

    private static String getInternalId(Dependency dep) {
        return dep.getGroupId() + ":" + dep.getArtifactId();
    }

    private static String getInternalId(Artifact art) {
        return art.getGroupId() + ":" + art.getArtifactId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void concatModuleScripts(File scriptDirectory) throws IOException, ProjectBuildingException {
        List<Artifact> jooArtifacts = this.getJangarooDependencies();
        Map<String, List<String>> artifact2Project = this.computeDependencyGraph(jooArtifacts);
        this.getLog().debug((CharSequence)("artifact2Project : " + artifact2Project));
        List<String> depsLineralized = PackageApplicationMojo.sort(artifact2Project);
        this.getLog().debug((CharSequence)("depsLineralized  : " + depsLineralized));
        Writer jangarooApplicationWriter = this.createJangarooModulesFile(scriptDirectory, "jangaroo-application.js");
        Writer jangarooApplicationAllWriter = this.createJangarooModulesFile(scriptDirectory, "jangaroo-application-all.js");
        try {
            jangarooApplicationWriter.write("// This file loads all collected JavaScript code from dependent Jangaroo modules.\n\n");
            jangarooApplicationAllWriter.write("// This file contains all collected JavaScript code from dependent Jangaroo modules.\n\n");
            Map<String, Artifact> internalId2Artifact = this.artifactByInternalId(jooArtifacts);
            for (String dependency : depsLineralized) {
                Artifact artifact = internalId2Artifact.get(dependency);
                if (artifact == null) continue;
                this.includeJangarooModuleScript(scriptDirectory, artifact, jangarooApplicationWriter, jangarooApplicationAllWriter);
            }
            this.writeThisJangarooModuleScript(scriptDirectory, jangarooApplicationWriter, jangarooApplicationAllWriter);
        }
        finally {
            try {
                jangarooApplicationWriter.close();
                jangarooApplicationAllWriter.close();
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)"IOException on close ignored.", (Throwable)e);
            }
        }
    }

    protected void writeThisJangarooModuleScript(File scriptDirectory, Writer jangarooApplicationWriter, Writer jangarooApplicationAllWriter) throws IOException {
        File jangarooModuleFile = new File(this.getPackageSourceDirectory(), PackageApplicationMojo.computeModuleJsFileName(this.project.getArtifactId()));
        FileModuleSource jooModuleSource = jangarooModuleFile.exists() ? new FileModuleSource(jangarooModuleFile) : null;
        this.writeJangarooModuleScript(scriptDirectory, this.project.getArtifact(), jooModuleSource, jangarooApplicationWriter, jangarooApplicationAllWriter);
    }

    private static String computeModuleJsFileName(String artifactId) {
        return "META-INF/resources/joo/" + artifactId + ".module.js";
    }

    private Writer createJangarooModulesFile(File scriptDirectory, String fileName) throws IOException {
        if (scriptDirectory.mkdirs()) {
            this.getLog().debug((CharSequence)("created script output directory " + scriptDirectory));
        }
        File f = new File(scriptDirectory, fileName);
        this.getLog().info((CharSequence)("Creating Jangaroo application script '" + f.getAbsolutePath() + "'."));
        return new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8");
    }

    private void includeJangarooModuleScript(File scriptDirectory, Artifact artifact, Writer jangarooApplicationWriter, Writer jangarooApplicationAllWriter) throws IOException {
        ZipFile zipFile = new ZipFile(artifact.getFile());
        ZipEntry zipEntry = zipFile.getEntry(PackageApplicationMojo.computeModuleJsFileName(artifact.getArtifactId()));
        ZipEntryModuleSource jooModuleSource = zipEntry != null ? new ZipEntryModuleSource(zipFile, zipEntry) : null;
        this.writeJangarooModuleScript(scriptDirectory, artifact, jooModuleSource, jangarooApplicationWriter, jangarooApplicationAllWriter);
    }

    private static String fromArtifactMessage(Artifact artifact) {
        return PackageApplicationMojo.fromArtifactMessage(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
    }

    private static String fromArtifactMessage(String groupId, String artifactId, String version) {
        return "// FROM " + PackageApplicationMojo.fullArtifactName(groupId, artifactId, version) + ":\n";
    }

    private static String fullArtifactName(Artifact artifact) {
        return PackageApplicationMojo.fullArtifactName(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
    }

    private static String fullArtifactName(String groupId, String artifactId, String version) {
        return String.format("%s:%s:%s", groupId, artifactId, version);
    }

    private void writeJangarooModuleScript(File scriptDirectory, Artifact artifact, ModuleSource jooModuleSource, Writer jangarooApplicationWriter, Writer jangarooApplicationAllWriter) throws IOException {
        String fullArtifactName = PackageApplicationMojo.fullArtifactName(artifact);
        if (jooModuleSource == null) {
            this.getLog().debug((CharSequence)("No " + artifact.getArtifactId() + ".module.js in " + fullArtifactName + "."));
            this.writeModule(scriptDirectory, artifact, jangarooApplicationWriter, jangarooApplicationAllWriter);
        } else {
            this.getLog().info((CharSequence)("Appending " + artifact.getArtifactId() + ".module.js from " + fullArtifactName));
            String fromMessage = PackageApplicationMojo.fromArtifactMessage(artifact);
            jangarooApplicationWriter.write(fromMessage);
            this.appendFromInputStream(jangarooApplicationWriter, jooModuleSource.getInputStream());
            jangarooApplicationAllWriter.write(fromMessage);
            this.writeModuleWithInlineScripts(scriptDirectory, jooModuleSource, jangarooApplicationAllWriter);
        }
    }

    private void writeModuleWithInlineScripts(File scriptDirectory, ModuleSource jooModuleSource, Writer jangarooApplicationAllWriter) throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(jooModuleSource.getInputStream(), "UTF-8"));
        while ((line = bufferedReader.readLine()) != null) {
            String scriptFilename = null;
            Matcher loadModuleMatcher = LOAD_MODULE_CODE_PATTERN.matcher(line);
            if (loadModuleMatcher.matches()) {
                String groupId = loadModuleMatcher.group(1);
                String artifactId = loadModuleMatcher.group(2);
                scriptFilename = "joo/" + groupId + "." + artifactId + ".classes.js";
                this.getLog().debug((CharSequence)(" found loadModule: " + groupId + " / " + artifactId));
            } else {
                Matcher loadScriptMatcher = LOAD_SCRIPT_CODE_PATTERN.matcher(line);
                if (loadScriptMatcher.matches()) {
                    scriptFilename = loadScriptMatcher.group(1);
                    this.getLog().debug((CharSequence)(" found loadScript: " + scriptFilename));
                }
            }
            File scriptFile = null;
            if (scriptFilename != null && !(scriptFile = new File(scriptDirectory.getParent(), scriptFilename)).exists()) {
                scriptFile = null;
            }
            if (scriptFile == null) {
                jangarooApplicationAllWriter.write(line + '\n');
                continue;
            }
            this.appendFile(jangarooApplicationAllWriter, scriptFile);
        }
    }

    private void writeModule(File scriptDirectory, Artifact artifact, Writer jangarooApplicationWriter, Writer jangarooApplicationAllWriter) throws IOException {
        this.writeModule(scriptDirectory, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), jangarooApplicationWriter, jangarooApplicationAllWriter);
    }

    protected void writeModule(File scriptDirectory, String groupId, String artifactId, String version, Writer jangarooApplicationWriter, Writer jangarooApplicationAllWriter) throws IOException {
        File classesJsFile = new File(scriptDirectory, groupId + "." + artifactId + ".classes.js");
        if (classesJsFile.exists()) {
            this.getLog().debug((CharSequence)("Creating joo.loadModule(...) code for / appending .classes.js of " + PackageApplicationMojo.fullArtifactName(groupId, artifactId, version) + "."));
            jangarooApplicationWriter.write(PackageApplicationMojo.fromArtifactMessage(groupId, artifactId, version));
            jangarooApplicationWriter.write("joo.loadModule(\"" + groupId + "\",\"" + artifactId + "\");\n");
            jangarooApplicationAllWriter.write(PackageApplicationMojo.fromArtifactMessage(groupId, artifactId, version));
            this.appendFile(jangarooApplicationAllWriter, classesJsFile);
        } else {
            this.getLog().debug((CharSequence)("No file " + classesJsFile.getAbsolutePath() + " in module " + PackageApplicationMojo.fullArtifactName(groupId, artifactId, version) + "."));
        }
    }

    private void appendFile(Writer writer, File file) throws IOException {
        this.appendFromInputStream(writer, (InputStream)new BOMStripperInputStream((InputStream)new FileInputStream(file)));
    }

    private void appendFromInputStream(Writer writer, InputStream inputStream) throws IOException {
        IOUtil.copy((InputStream)inputStream, (Writer)writer, (String)"UTF-8");
        writer.write(10);
    }

    private Map<String, Artifact> artifactByInternalId(List<Artifact> jooArtifacts) {
        HashMap<String, Artifact> internalId2Artifact = new HashMap<String, Artifact>();
        for (Artifact artifact : jooArtifacts) {
            String internalId = PackageApplicationMojo.getInternalId(artifact);
            internalId2Artifact.put(internalId, artifact);
        }
        return internalId2Artifact;
    }

    private List<Artifact> getJangarooDependencies() {
        ArrayList<Artifact> jooArtifacts = new ArrayList<Artifact>();
        for (Artifact dependency : this.getArtifacts()) {
            if (!"jar".equals(dependency.getType())) continue;
            jooArtifacts.add(dependency);
        }
        return jooArtifacts;
    }

    private Map<String, List<String>> computeDependencyGraph(List<Artifact> artifacts) throws ProjectBuildingException {
        HashMap<String, List<String>> artifact2Project = new HashMap<String, List<String>>();
        for (Artifact artifact : artifacts) {
            MavenProject mp = this.mavenProjectBuilder.buildFromRepository(artifact, this.remoteRepositories, this.localRepository, true);
            LinkedList<String> deps = new LinkedList<String>();
            for (Dependency dep : PackageApplicationMojo.getDependencies(mp)) {
                if (!"jar".equals(dep.getType())) continue;
                deps.add(PackageApplicationMojo.getInternalId(dep));
            }
            String internalId = PackageApplicationMojo.getInternalId(artifact);
            artifact2Project.put(internalId, deps);
        }
        return artifact2Project;
    }

    private static List<Dependency> getDependencies(MavenProject mp) {
        return mp.getDependencies();
    }

    protected Set<Artifact> getArtifacts() {
        return this.project.getArtifacts();
    }

    private static class ZipEntryModuleSource
    implements ModuleSource {
        private final ZipFile zipFile;
        private final ZipEntry zipEntry;

        private ZipEntryModuleSource(ZipFile zipFile, ZipEntry zipEntry) {
            this.zipFile = zipFile;
            this.zipEntry = zipEntry;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new BOMStripperInputStream(this.zipFile.getInputStream(this.zipEntry));
        }
    }

    private static class FileModuleSource
    implements ModuleSource {
        private final File file;

        private FileModuleSource(File file) {
            this.file = file;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new BOMStripperInputStream((InputStream)new FileInputStream(this.file));
        }
    }

    private static interface ModuleSource {
        public InputStream getInputStream() throws IOException;
    }
}

