/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;

public class MavenPluginHelper {
    private MavenProject project;
    private Log log;

    public MavenPluginHelper(MavenProject project, Log log) {
        this.project = project;
        this.log = log;
    }

    public List<File> computeStaleSources(List<File> compileSourceRoots, Set<String> includes, Set<String> excludes, File outputDirectory, String inputFileSuffix, String outputFileSuffix, int staleMillis) throws MojoExecutionException {
        SourceInclusionScanner scanner = this.createSourceInclusionScanner(includes, excludes, inputFileSuffix, staleMillis);
        scanner.addSourceMapping((SourceMapping)new SuffixMapping(inputFileSuffix, outputFileSuffix));
        this.log.debug((CharSequence)"Searching for");
        LinkedHashSet staleSources = new LinkedHashSet();
        for (File rootFile : compileSourceRoots) {
            if (!rootFile.isDirectory()) continue;
            try {
                this.log.debug((CharSequence)("scanner.getIncludedSources(" + rootFile + ", " + outputDirectory + ")"));
                staleSources.addAll(scanner.getIncludedSources(rootFile, outputDirectory));
            }
            catch (InclusionScanException e) {
                throw new MojoExecutionException("Error scanning source root: '" + rootFile.getAbsolutePath() + "' " + "for stale files to recompile.", (Exception)((Object)e));
            }
        }
        return Collections.unmodifiableList(new ArrayList(staleSources));
    }

    private SourceInclusionScanner createSourceInclusionScanner(Set<String> includes, Set<String> excludes, String inputFileSuffix, int staleMillis) {
        StaleSourceScanner scanner;
        if (staleMillis >= 0 && includes.isEmpty() && excludes.isEmpty()) {
            scanner = new StaleSourceScanner((long)staleMillis);
        } else {
            if (includes.isEmpty()) {
                includes.add("**/*" + inputFileSuffix);
            }
            scanner = staleMillis >= 0 ? new StaleSourceScanner((long)staleMillis, includes, excludes) : new SimpleSourceInclusionScanner(includes, excludes);
        }
        this.log.debug((CharSequence)("Using source inclusion scanner " + scanner));
        return scanner;
    }

    public List<File> getActionScriptClassPath(boolean includeTestScope) {
        ArrayList<File> classPath = new ArrayList<File>();
        Set<Artifact> dependencies = this.getArtifacts();
        for (Artifact dependency : dependencies) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("Dependency: " + dependency.getGroupId() + ":" + dependency.getArtifactId() + " type: " + dependency.getType()));
            }
            if (dependency.isOptional() || !"compile".equals(dependency.getScope()) && (!includeTestScope || !"test".equals(dependency.getScope())) || !"jar".equals(dependency.getType())) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("adding to classpath: compile dependency [" + dependency.toString() + "]"));
            }
            classPath.add(dependency.getFile());
        }
        File jooApiDir = new File(this.project.getBasedir(), "src/main/joo-api");
        if (jooApiDir.exists()) {
            classPath.add(0, jooApiDir);
        }
        return classPath;
    }

    public Set<Artifact> getArtifacts() {
        return this.project.getArtifacts();
    }
}

