/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jangaroo.jooc.AbstractCompileLog;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.api.CompileLog;
import net.jangaroo.jooc.config.DebugMode;
import net.jangaroo.jooc.config.JoocConfiguration;
import net.jangaroo.jooc.config.PublicApiViolationsMode;
import net.jangaroo.jooc.config.SemicolonInsertionMode;
import net.jangaroo.jooc.mvnplugin.JangarooMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.compiler.CompilerError;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractCompilerMojo
extends JangarooMojo {
    private MavenProject project;
    private boolean failOnError = true;
    private boolean enableAssertions;
    private boolean allowDuplicateLocalVariables;
    private String publicApiViolations;
    private boolean excludeClassByDefault;
    private boolean verbose;
    private int staleMillis;
    private String debuglevel;
    private String autoSemicolon;
    protected File sourceDirectory;
    private File generatedSourcesDirectory;

    @Override
    protected MavenProject getProject() {
        return this.project;
    }

    public abstract String getModuleClassesJsFileName();

    public File getModuleClassesJsFile() {
        return new File(this.getOutputDirectory(), this.getModuleClassesJsFileName());
    }

    protected abstract List<File> getCompileSourceRoots();

    protected abstract File getOutputDirectory();

    protected File getClassesOutputDirectory() {
        return new File(this.getOutputDirectory(), "joo/classes");
    }

    protected abstract File getTempClassesOutputDirectory();

    public File getGeneratedSourcesDirectory() {
        return this.generatedSourcesDirectory;
    }

    protected abstract File getApiOutputDirectory();

    public void execute() throws MojoExecutionException, MojoFailureException {
        int result;
        boolean compilationError;
        Log log = this.getLog();
        if (this.getCompileSourceRoots().isEmpty()) {
            log.info((CharSequence)"No sources to compile");
            return;
        }
        JoocConfiguration configuration = new JoocConfiguration();
        configuration.setEnableAssertions(this.enableAssertions);
        configuration.setAllowDuplicateLocalVariables(this.allowDuplicateLocalVariables);
        configuration.setVerbose(this.verbose);
        configuration.setExcludeClassByDefault(this.excludeClassByDefault);
        if (StringUtils.isNotEmpty((String)this.debuglevel)) {
            try {
                configuration.setDebugMode(DebugMode.valueOf((String)this.debuglevel.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("The specified debug level: '" + this.debuglevel + "' is unsupported. Legal values are 'none', 'lines', and 'source'.");
            }
        }
        if (StringUtils.isNotEmpty((String)this.autoSemicolon)) {
            try {
                configuration.setSemicolonInsertionMode(SemicolonInsertionMode.valueOf((String)this.autoSemicolon.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("The specified semicolon insertion mode: '" + this.autoSemicolon + "' is unsupported. Legal values are 'error', 'warn', and 'quirks'.");
            }
        }
        if (StringUtils.isNotEmpty((String)this.publicApiViolations)) {
            try {
                configuration.setPublicApiViolationsMode(PublicApiViolationsMode.valueOf((String)this.publicApiViolations.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("The specified public API violations mode: '" + this.publicApiViolations + "' is unsupported. Legal values are 'error', 'warn', and 'allow'.");
            }
        }
        HashSet<File> sources = new HashSet<File>();
        log.debug((CharSequence)"starting source inclusion scanner");
        sources.addAll(this.computeStaleSources(this.staleMillis));
        if (sources.isEmpty()) {
            log.info((CharSequence)"Nothing to compile - all classes are up to date");
            return;
        }
        configuration.setSourceFiles(new ArrayList(sources));
        try {
            configuration.setSourcePath(this.getCompileSourceRoots());
        }
        catch (IOException e) {
            throw new MojoFailureException("could not canonicalize source paths: " + this.getCompileSourceRoots(), (Throwable)e);
        }
        configuration.setClassPath(this.getActionScriptClassPath());
        configuration.setOutputDirectory(this.getClassesOutputDirectory());
        configuration.setApiOutputDirectory(this.getApiOutputDirectory());
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Source path: " + configuration.getSourcePath().toString().replace(',', '\n')));
            log.debug((CharSequence)("Class path: " + configuration.getClassPath().toString().replace(',', '\n')));
            log.debug((CharSequence)("Output directory: " + configuration.getOutputDirectory()));
            if (configuration.getApiOutputDirectory() != null) {
                log.debug((CharSequence)("API output directory: " + configuration.getApiOutputDirectory()));
            }
        }
        boolean bl = compilationError = (result = this.compile(configuration)) != 0;
        if (!compilationError) {
            configuration.setDebugMode(null);
            configuration.setOutputDirectory(this.getTempClassesOutputDirectory());
            configuration.setApiOutputDirectory(null);
            result = this.compile(configuration);
            if (result == 0) {
                this.buildOutputFile(this.getTempClassesOutputDirectory(), this.getModuleClassesJsFile());
            }
            compilationError = result != 0;
        }
        List<CompilerError> messages = Collections.emptyList();
        if (compilationError && this.failOnError) {
            log.info((CharSequence)"-------------------------------------------------------------");
            log.error((CharSequence)"COMPILATION ERROR : ");
            log.info((CharSequence)"-------------------------------------------------------------");
            if (messages != null) {
                for (CompilerError message : messages) {
                    log.error((CharSequence)message.toString());
                }
                log.info((CharSequence)(messages.size() + (messages.size() > 1 ? " errors " : "error")));
                log.info((CharSequence)"-------------------------------------------------------------");
            }
            throw new MojoFailureException("Compilation failed");
        }
        for (CompilerError message : messages) {
            log.warn((CharSequence)message.toString());
        }
    }

    protected abstract List<File> getActionScriptClassPath();

    private void buildOutputFile(File tempOutputDir, File outputFile) throws MojoExecutionException {
        Log log = this.getLog();
        if (log.isDebugEnabled()) {
            log.debug((CharSequence)("Output file: " + outputFile));
        }
        try {
            File outputFileDirectory = outputFile.getParentFile();
            if (!outputFileDirectory.exists() && outputFileDirectory.mkdirs()) {
                log.debug((CharSequence)("created output directory " + outputFileDirectory));
            }
            List files = FileUtils.getFiles((File)tempOutputDir, (String)"**/*.js", (String)"**/*_properties_*.js");
            OutputStreamWriter fos = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8");
            int tempOutputDirPathLength = tempOutputDir.getAbsolutePath().length() + 1;
            for (File file : files) {
                String className = file.getAbsolutePath();
                className = className.substring(tempOutputDirPathLength, className.length() - ".js".length());
                className = className.replace(File.separatorChar, '.');
                fos.write("// class " + className + "\n");
                IOUtil.copy((InputStream)new FileInputStream(file), (Writer)fos, (String)"UTF-8");
                ((Writer)fos).write(10);
            }
            ((Writer)fos).close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("could not build output file " + outputFile + ": " + e.toString(), (Exception)e);
        }
    }

    private int compile(JoocConfiguration config) throws MojoExecutionException {
        File outputDirectory = config.getOutputDirectory();
        if (!outputDirectory.exists() && !outputDirectory.mkdirs()) {
            throw new MojoExecutionException("Failed to create output directory " + outputDirectory.getAbsolutePath());
        }
        File apiOutputDirectory = this.getApiOutputDirectory();
        if (apiOutputDirectory != null && !apiOutputDirectory.exists() && !apiOutputDirectory.mkdirs()) {
            throw new MojoExecutionException("Failed to create api output directory " + apiOutputDirectory.getAbsolutePath());
        }
        List sources = config.getSourceFiles();
        final Log log = this.getLog();
        log.info((CharSequence)("Compiling " + sources.size() + " joo source file" + (sources.size() == 1 ? "" : "s") + " to " + outputDirectory));
        Jooc jooc = new Jooc(config, (CompileLog)new AbstractCompileLog(){

            protected void doLogError(String msg) {
                log.error((CharSequence)msg);
            }

            public void warning(String msg) {
                log.warn((CharSequence)msg);
            }
        });
        return jooc.run().getResultCode();
    }

    private List<File> computeStaleSources(int staleMillis) throws MojoExecutionException {
        File outputDirectory = this.getClassesOutputDirectory();
        List<File> compileSourceRoots = this.getCompileSourceRoots();
        return this.getMavenPluginHelper().computeStaleSources(compileSourceRoots, this.getIncludes(), this.getExcludes(), outputDirectory, ".as", ".js", staleMillis);
    }

    protected abstract Set<String> getIncludes();

    protected abstract Set<String> getExcludes();

    protected boolean isJangarooPackaging() {
        return "jangaroo".equals(this.getProject().getPackaging());
    }
}

