/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jangaroo.jooc.PackagerImpl;
import net.jangaroo.jooc.json.JsonObject;
import net.jangaroo.jooc.mvnplugin.AbstractSenchaPackageOrAppMojo;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaProfileConfiguration;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;
import net.jangaroo.jooc.mvnplugin.sencha.configbuilder.SenchaPackageConfigBuilder;
import net.jangaroo.jooc.mvnplugin.util.FileHelper;
import net.jangaroo.utils.CompilerUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="package-pkg", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyCollection=ResolutionScope.COMPILE, threadSafe=true)
public class SenchaPackageMojo
extends AbstractSenchaPackageOrAppMojo<SenchaPackageConfigBuilder> {
    @Parameter(defaultValue="code")
    private String packageType;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private String buildDirectoryPath;
    private File senchaPackageDirectory;
    @Parameter
    private Map<String, String> globalResourcesMap;

    @Override
    public String getType() {
        if ("code".equals(this.packageType) || "theme".equals(this.packageType)) {
            return this.packageType;
        }
        this.getLog().error((CharSequence)String.format("%s is not a valid packaging packageType. Using \"code\" instead.", this.packageType));
        this.packageType = "code";
        return this.packageType;
    }

    @Override
    public String getJsonConfigFileName() {
        return "package.json";
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!"pkg".equals(this.project.getPackaging()) && !"swc".equals(this.project.getPackaging())) {
            throw new MojoExecutionException("This goal only supports projects with packaging type \"pkg\" or \"swc\"");
        }
        this.getLog().info((CharSequence)"Execute sencha packaging mojo");
        FileHelper.ensureDirectory(new File(this.getSenchaPackageDirectory().getPath()));
        SenchaPackageConfigBuilder configBuilder = this.createSenchaConfigBuilder();
        this.configure(configBuilder);
        this.prepareModule(configBuilder);
    }

    public void prepareModule(SenchaPackageConfigBuilder configBuilder) throws MojoExecutionException {
        this.writePackageConfig();
        this.writePackageJson(configBuilder);
        this.compileJavaScriptSources(this.getSenchaPackageDirectory());
        this.writeSenchaCfgFile();
    }

    private void writeSenchaCfgFile() throws MojoExecutionException {
        File senchaCfg = new File(this.getSenchaPackageDirectory().getPath(), ".sencha/packages/sencha.cfg");
        this.getLog().info((CharSequence)"Write .sencha/packages/sencha.cfg");
        try {
            Files.createParentDirs((File)senchaCfg);
            Files.touch((File)senchaCfg);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create " + senchaCfg.getAbsolutePath(), (Exception)e);
        }
    }

    private void compileJavaScriptSources(File dir) throws MojoExecutionException {
        try {
            new PackagerImpl().doPackage(new File(dir, "src"), new File(dir, "overrides"), new File(dir, "locale"), dir, SenchaUtils.getSenchaPackageName(this.project));
        }
        catch (IOException e) {
            throw new MojoExecutionException("exception while packaging JavaScript sources", (Exception)e);
        }
    }

    private void writePackageJson(SenchaPackageConfigBuilder configBuilder) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Write package.json file");
        SenchaUtils.writeFile(configBuilder, this.getSenchaPackageDirectory().getPath(), "package.json", null, this.getLog());
    }

    private void configure(SenchaPackageConfigBuilder configBuilder) throws MojoExecutionException {
        SenchaUtils.configureDefaults(configBuilder, "default.package.json");
        super.configure(configBuilder);
        configBuilder.type("theme".equals(this.getType()) ? "theme" : "code");
        this.addRequiredClasses(configBuilder, null, this.getRequiredClasses());
        this.addRequiredClasses(configBuilder, "production", SenchaPackageMojo.getRequiredClassesFromConfiguration(this.getProduction()));
        this.addRequiredClasses(configBuilder, "testing", SenchaPackageMojo.getRequiredClassesFromConfiguration(this.getTesting()));
        this.addRequiredClasses(configBuilder, "development", SenchaPackageMojo.getRequiredClassesFromConfiguration(this.getDevelopment()));
    }

    @Nonnull
    private static List<String> getRequiredClassesFromConfiguration(@Nullable SenchaProfileConfiguration configuration) {
        return configuration == null ? Collections.emptyList() : configuration.getRequiredClasses();
    }

    protected void addRequiredClasses(@Nonnull SenchaPackageConfigBuilder configBuilder, @Nullable String profile, @Nonnull List<String> requiredClassesForProfile) throws MojoExecutionException {
        if (requiredClassesForProfile.isEmpty()) {
            return;
        }
        File requireResourceFile = new File(SenchaPackageMojo.getRequiredClassesFileName(profile, this.getSenchaPackageDirectory().getPath(), File.separator));
        if (requireResourceFile.exists()) {
            this.getLog().info((CharSequence)"requireResourceFile file for require editor plugins already exists, deleting...");
            if (!requireResourceFile.delete()) {
                throw new MojoExecutionException("Could not delete requireResourceFile file for require editor plugins");
            }
        }
        this.writeRequireResourceFile(requireResourceFile, requiredClassesForProfile);
        if (profile == null) {
            configBuilder.js(SenchaPackageMojo.getRequiredClassesFileName(null, null, "/"), false, true);
        } else {
            SenchaPackageConfigBuilder requiredCLassesConfigBuilder = new SenchaPackageConfigBuilder();
            requiredCLassesConfigBuilder.js(SenchaPackageMojo.getRequiredClassesFileName(profile, null, "/"), false, true);
            configBuilder.profile(profile, requiredCLassesConfigBuilder.build());
        }
    }

    @Nonnull
    private static String getRequiredClassesFileName(@Nullable String profile, String baseDir, String separator) {
        StringBuilder nameBuilder = new StringBuilder();
        if (baseDir != null) {
            nameBuilder.append(baseDir).append(separator);
        }
        nameBuilder.append("bundledResources").append(separator);
        if (profile != null) {
            nameBuilder.append(profile).append(separator);
        }
        nameBuilder.append("requiredClasses.js");
        return nameBuilder.toString();
    }

    private void writeRequireResourceFile(File requireResourceFile, List<String> requiredClasses) throws MojoExecutionException {
        this.getLog().info((CharSequence)String.format("Write %s for module", requireResourceFile.getPath()));
        FileHelper.ensureDirectory(requireResourceFile.getParentFile());
        try (PrintWriter pw = new PrintWriter(new FileWriter(requireResourceFile, true));){
            for (String requiredClass : requiredClasses) {
                pw.printf("Ext.require(%s);%n", CompilerUtils.quote((String)requiredClass));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not write require resource file", (Exception)e);
        }
    }

    private void writePackageConfig() throws MojoExecutionException {
        if (this.globalResourcesMap == null || this.globalResourcesMap.isEmpty()) {
            return;
        }
        this.getLog().info((CharSequence)String.format("Write %s for module", "packageConfig.js"));
        String senchaPackageBuildOutputDirectoryPath = this.buildDirectoryPath + SenchaUtils.getPackagesPath(this.project);
        File packageConfigJsFile = new File(senchaPackageBuildOutputDirectoryPath + "/src/" + "packageConfig.js");
        FileHelper.ensureDirectory(packageConfigJsFile.getParentFile());
        if (packageConfigJsFile.exists()) {
            this.getLog().debug((CharSequence)"packageConfig.js for module already exists, deleting...");
            if (!packageConfigJsFile.delete()) {
                throw new MojoExecutionException("Could not delete packageConfig.js file for module");
            }
        }
        try (PrintWriter pw = new PrintWriter(new FileWriter(packageConfigJsFile, true));){
            this.writeGlobalResourceMapJs(pw);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create packageConfig.js resource", (Exception)e);
        }
    }

    private void writeGlobalResourceMapJs(PrintWriter pw) throws MojoExecutionException {
        String senchaPackageName = SenchaUtils.getSenchaPackageName(this.project);
        this.getLog().info((CharSequence)"Write global resource map JavaScript for packageConfig.js");
        pw.printf("// START - Adding global resources to ext manifest%n", new Object[0]);
        JsonObject globalResourcesMapAsJson = new JsonObject(new Object[0]);
        for (Map.Entry<String, String> resourceEntry : this.globalResourcesMap.entrySet()) {
            globalResourcesMapAsJson.set(resourceEntry.getKey(), (Object)("<@" + senchaPackageName + ">" + resourceEntry.getValue()));
        }
        pw.printf("Ext.registerGlobalResources(" + globalResourcesMapAsJson.toString(2) + ");%n", new Object[0]);
        pw.println("// END - Adding global resources to ext manifest");
    }

    public File getSenchaPackageDirectory() {
        if (this.senchaPackageDirectory == null) {
            this.senchaPackageDirectory = new File(this.buildDirectoryPath + SenchaUtils.getPackagesPath(this.project));
        }
        return this.senchaPackageDirectory;
    }

    @Override
    protected SenchaPackageConfigBuilder createSenchaConfigBuilder() {
        return new SenchaPackageConfigBuilder();
    }
}

