/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;

public class MavenDependencyHelper {
    private MavenDependencyHelper() {
    }

    public static Dependency createDependency(String groupId, String artifactId, String type, String version) {
        Dependency dependency = new Dependency();
        dependency.setArtifactId(artifactId);
        dependency.setGroupId(groupId);
        dependency.setType(type);
        dependency.setVersion(version);
        return dependency;
    }

    public static Dependency fromArtifact(Artifact artifact) {
        Dependency dependency = MavenDependencyHelper.createDependency(artifact.getGroupId(), artifact.getArtifactId(), artifact.getType(), artifact.getVersion());
        dependency.setScope(artifact.getScope());
        return dependency;
    }

    public static Dependency fromProject(MavenProject project) {
        return MavenDependencyHelper.createDependency(project.getGroupId(), project.getArtifactId(), null, null);
    }

    public static Dependency fromKey(String key) {
        Dependency result = new Dependency();
        if (key != null) {
            String[] coordinates = key.split(":");
            result.setGroupId(MavenDependencyHelper.getArrayItemSafe(coordinates, 0));
            result.setArtifactId(MavenDependencyHelper.getArrayItemSafe(coordinates, 1));
            result.setScope(MavenDependencyHelper.getArrayItemSafe(coordinates, 2));
            result.setType(MavenDependencyHelper.getArrayItemSafe(coordinates, 3));
            return result;
        }
        return result;
    }

    private static String getArrayItemSafe(String[] array, int index) {
        return array.length >= index + 1 ? array[index] : "";
    }

    public static boolean equalsGroupIdAndArtifactId(Dependency dependency1, Dependency dependency2) {
        return Objects.equals(dependency1, dependency2) || dependency1 != null && dependency2 != null && Objects.equals(dependency1.getArtifactId(), dependency2.getArtifactId()) && Objects.equals(dependency1.getGroupId(), dependency2.getGroupId());
    }

    public static boolean contains(Collection<Dependency> dependencies, final Dependency dependency) {
        return Iterables.tryFind(dependencies, (Predicate)new Predicate<Dependency>(){

            public boolean apply(@Nullable Dependency input) {
                return MavenDependencyHelper.equalsGroupIdAndArtifactId(input, dependency);
            }
        }).isPresent();
    }

    public static boolean remove(Collection<Dependency> dependencies, final Dependency dependency) {
        return Iterables.removeIf(dependencies, (Predicate)new Predicate<Dependency>(){

            public boolean apply(@Nullable Dependency input) {
                return MavenDependencyHelper.equalsGroupIdAndArtifactId(input, dependency);
            }
        });
    }
}

