/*
 * Copyright 2009 CoreMedia AG
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 
 *
 * Unless required by applicable law or agreed to in writing, 
 * software distributed under the License is distributed on an "AS
 * IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either 
 * express or implied. See the License for the specific language 
 * governing permissions and limitations under the License.
 */

// JangarooScript runtime support. Author: Frank Wienberg

package joo {

public class NativeClassDeclaration {

  internal static native function createEmptyConstructor(constructor_ : Function) : Function;

  internal static const STATE_LOADED : int = 0;
  internal static const STATE_COMPLETING : int = 1;
  internal static const STATE_COMPLETED : int = 2;
  internal static const STATE_INITIALIZING : int = 3;
  internal static const STATE_INITIALIZED : int = 4;

  public var
          level : int = -1,
          fullClassName : String,
          constructor_ : Function,
          publicConstructor : Function,
          state  : int = joo.NativeClassDeclaration.STATE_LOADED,
          Public : Function,
          superClassDeclaration : NativeClassDeclaration,
          interfaces : Array;

  public native function NativeClassDeclaration();

  public native function create(fullClassName : String, publicConstructor : Function) : NativeClassDeclaration;

  public native function complete() : NativeClassDeclaration;

  protected native function doComplete() : void;

  public native function init() : NativeClassDeclaration;

  protected native function doInit() : void;

  public native function isInstance(object : Object) : Boolean;

  public native function getQualifiedName() : String;

  public native function toString() : String;
}
}