/*
 * Copyright 2009 CoreMedia AG
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 
 *
 * Unless required by applicable law or agreed to in writing, 
 * software distributed under the License is distributed on an "AS
 * IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either 
 * express or implied. See the License for the specific language 
 * governing permissions and limitations under the License.
 */

// JangarooScript runtime support. Author: Frank Wienberg

package joo {

public class SystemClassDeclaration extends joo.NativeClassDeclaration {

  protected static native function createPublicConstructor(cd : NativeClassDeclaration) : Function;

  protected var
          package_ : Object,
          type : String = joo.MemberDeclaration.MEMBER_TYPE_CLASS,
          namespace_ : String = joo.MemberDeclaration.NAMESPACE_INTERNAL,
          className : String,
          native_ : Boolean = false,
          extends_ : String = "Object",
          privateStatics : Object,
          memberDeclarations : * /* Function, then Array */,
          memberDeclarationsByQualifiedName : Object,
          staticInitializers : Array/*<MemberDeclaration>*/,
          publicStaticMethodNames : Array;
  /**
   * The metadata (annotations) associated with this class.
   */
  public var metadata : Object = {};

  public native function SystemClassDeclaration(packageDef : String, classDef : String, memberDeclarations : Function,
          publicStaticMethodNames : Array);

  public native function isClass() : Boolean;

  public native function isInterface() : Boolean;

  public native function isNamespace() : Boolean;

  public native function isNative() : Boolean;

  protected override native function doComplete() : void;

  protected native function initMembers() : void;

  protected native function initMethod(memberDeclaration : MemberDeclaration, member : Function) : void;

  protected native function _createMemberDeclaration(memberDeclaration : MemberDeclaration, changedProperties : Object) : MemberDeclaration;

  protected native function _storeMember(memberDeclaration : MemberDeclaration, value : Object) : void;

  protected override native function doInit() : void;

  public native function getMemberDeclaration(namespace_ : String, memberName : String) : MemberDeclaration;
}
}