/*
 * Copyright 2009 CoreMedia AG
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 
 *
 * Unless required by applicable law or agreed to in writing, 
 * software distributed under the License is distributed on an "AS
 * IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either 
 * express or implied. See the License for the specific language 
 * governing permissions and limitations under the License.
 */

// JangarooScript runtime support. Author: Frank Wienberg

package joo {

public class SystemClassLoader {

  public static const classDeclarationsByName : Object/*<String,SystemClassDeclaration>*/ = {};

  public var debug : Boolean = false;

  public native function SystemClassLoader();

  public native function prepare(...params) : SystemClassDeclaration;

  /**
   * @internal
   * Used for runtime-to-class compatibility check. <code>internal</code>, not <code>private</code>, for testing purposes.
   * A class runtimeApiVersion/compilerVersion is compatible with the current Runtime if
   * <ul>
   * <li>the runtimeApiVersion matches the Runtime's runtimeApiVersion exactly and</li>
   * <li>the compilerVersion is lower or the same as the Runtime's compilerVersion.</li>
   * </ul>
   * @param runtimeApiVersion the runtime API version to check for compatibility with the loaded Jangaroo Runtime
   * @param compilerVersion the compiler version to check for compatibility with the loaded Jangaroo Runtime
   * @return Boolean whether the given runtimeApiVersion/compilerVersion is compatible with the current Runtime.
   */
  internal static native function isRuntimeCompatible(runtimeApiVersion:String, compilerVersion:String):Boolean;

  static native function addToMetadata(metadata:Object, annotation:*):void;

  protected native function createClassDeclaration(packageDef : String, classDef : String, memberFactory : Function,
                          publicStaticMethodNames : Array, dependencies : Array) : SystemClassDeclaration;

  public native function getClassDeclaration(fullClassName : String) : NativeClassDeclaration;

  /**
   * @param className
   * @return NativeClassDeclaration the class declaration with the given name.
   * @throws Error - ClassNotFound
   */
  public native function getRequiredClassDeclaration(className : String) : NativeClassDeclaration;

  protected native function createNativeClassDeclaration(fullClassName : String, nativeClass : Function) : NativeClassDeclaration;

  public native function init(... classes) :Function;
}
}