/*
 * Copyright 2009 CoreMedia AG
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 
 *
 * Unless required by applicable law or agreed to in writing, 
 * software distributed under the License is distributed on an "AS
 * IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either 
 * express or implied. See the License for the specific language 
 * governing permissions and limitations under the License.
 */

// JangarooScript runtime support. Author: Frank Wienberg

package joo {

public class JooClassDeclaration extends NativeClassDeclaration {

  public static const STATE_EVENT_AFTER_INIT_MEMBERS:String = 'afterInitMembers';

  internal var
          package_ : Object,
          type : String,
          namespace_ : String,
          className : String,
          native_ : Boolean = false,
          extends_ : String = "Object",
          level : int = -1,
          privateStatics : Object,
          memberDeclarations : * /* Function, then Array */,
          memberDeclarationsByQualifiedName : Object,
          staticInitializers : Array/*<MemberDeclaration|Function>*/,
          publicStaticMethodNames : Array,
          implementingClasses: Array/*Class*/,
          dependencies : Array,
          stateListeners: Object;
  /**
   * The metadata (annotations) associated with this class.
   */
  public var metadata : Object;

  public function JooClassDeclaration(packageDef:String, metadata:Object, classDef:String, inheritanceLevel:int, memberDeclarations:Function, publicStaticMethodNames:Array, dependencies:Array){super();}

  public native function addStateListener(state:String, listener:Function):void;

  public native function removeStateListener(state:String, listener:Function):void;

  public native function isClass() : Boolean;

  public native function isInterface() : Boolean;

  internal native function addToInterfaces(clazz:Function):void;

  internal native function addImplementingClass(clazz:Function):void;

  override public native function isInstance(obj:Object):Boolean;

  public native function isNamespace() : Boolean;

  public native function isNative() : Boolean;

  internal override native function doComplete() : void;

  internal native function initMembers() : void;

  internal native function _setConstructor(constructor_:Function):void;

  internal native function initMethod(memberDeclaration : MemberDeclaration, member : Function) : void;

  internal native function _createMemberDeclaration(memberDeclaration : MemberDeclaration, changedProperties : Object) : MemberDeclaration;

  internal native function _storeMember(memberDeclaration : MemberDeclaration, value : Object) : void;

  internal native function _processMetadata(memberDeclaration : MemberDeclaration = null):void;

  internal override native function doInit() : void;

  internal native function fireStateEvent(event:String):void;

  public native function getMemberDeclaration(namespace_ : String, memberName : String) : MemberDeclaration;

  public native function getDependencies() : Array;

  internal native function createInitializingStaticMethod(methodName : String) : void;
}
}