/*
 * Copyright 2009 CoreMedia AG
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 
 *
 * Unless required by applicable law or agreed to in writing, 
 * software distributed under the License is distributed on an "AS
 * IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either 
 * express or implied. See the License for the specific language 
 * governing permissions and limitations under the License.
 */

// JangarooScript runtime support. Author: Frank Wienberg

package joo {
import joo.MemberDeclaration;
import joo.NativeClassDeclaration;

public class JooClassDeclaration extends NativeClassDeclaration {

  public static const STATE_EVENT_AFTER_INIT_MEMBERS:String = 'afterInitMembers';
  /**
   * The metadata (annotations) associated with this class.
   */
  public var metadata : Object;

  public function JooClassDeclaration(packageDef:String, metadata:Object, classDef:String, inheritanceLevel:int, memberDeclarations:Function, publicStaticMethodNames:Array, dependencies:Array){super();}

  public native function addStateListener(state:String, listener:Function):void;

  public native function removeStateListener(state:String, listener:Function):void;

  public native function isClass() : Boolean;

  public native function isInterface() : Boolean;

  override public native function isInstance(obj:Object):Boolean;

  public native function isNamespace() : Boolean;

  public native function isNative() : Boolean;

  public native function getMemberDeclaration(namespace_ : String, memberName : String) : MemberDeclaration;

  public native function getDependencies() : Array;
}
}