/*
 * Copyright 2009 CoreMedia AG
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 
 *
 * Unless required by applicable law or agreed to in writing, 
 * software distributed under the License is distributed on an "AS
 * IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either 
 * express or implied. See the License for the specific language 
 * governing permissions and limitations under the License.
 */

// JangarooScript runtime support. Author: Frank Wienberg

package joo {

public class MemberDeclaration {

  public static const
          METHOD_TYPE_GET : String = "get",
          METHOD_TYPE_SET : String,
          MEMBER_TYPE_VAR : String,
          MEMBER_TYPE_CONST : String,
          MEMBER_TYPE_FUNCTION : String,
          MEMBER_TYPE_CLASS : String,
          MEMBER_TYPE_INTERFACE : String,
          MEMBER_TYPE_NAMESPACE : String,
          NAMESPACE_PRIVATE : String,
          NAMESPACE_INTERNAL : String,
          NAMESPACE_PROTECTED : String,
          NAMESPACE_PUBLIC : String,
          STATIC : String,
          FINAL : String,
          NATIVE : String,
          OVERRIDE : String,
          VIRTUAL : String;

  public static native function create(memberDeclarationStr : String) : MemberDeclaration;
  public var
          memberType : String,
          getterOrSetter : String,
          memberName : String,
          slot : String,
          value : *;
  /**
   * The metadata (annotations) associated with this member.
   */
  public var metadata : Object;

  public function MemberDeclaration(tokens : Array){super();}

  public native function getQualifiedName() : String;

  public native function isPrivate() : Boolean;

  public native function isStatic() : Boolean;

  public native function isFinal() : Boolean;

  public native function isNative() : Boolean;

  public native function isOverride() : Boolean;

  public native function isMethod() : Boolean;

  // public function retrieveMember(source : Object) : Function
  /* not needed if we take reflection seriously!
   retrieveMember: function joo$MemberDeclaration$getMember(source) {
   return this.getterOrSetter==METHOD_TYPE_GET ? source.__lookupGetter__(this.memberName)
   : this.getterOrSetter==METHOD_TYPE_SET ? source.__lookupSetter__(this.memberName)
   : source[this.memberName];
   },*/

  public native function getNativeMember(publicConstructor : Function) : *;

  public native function hasOwnMember(target : Object) : Boolean;

  public native function retrieveMember(target : Object) : *;

  public native function storeMember(target : Object) : void;

  public native function hasInitializer() : Boolean;

  public native function _getCloneFactory() : Function;

  public native function clone(changedProperties : Object) : MemberDeclaration;

  public native function toString() : String;

}
}