joo.classLoader.prepare("package ext.config",/* {*/


/**
 * Provides for repetitive polling of the server at distinct <a href="output/Ext.direct.PollingProvider.html#Ext.direct.PollingProvider-interval">intervals</a>. The initial request for data originates from the client, and then is responded to by the server.
 <p>All configurations for the PollingProvider should be generated by the server-side API portion of the Ext.Direct stack.</p><p>An instance of PollingProvider may be created directly via the new keyword or by simply specifying <tt>type = 'polling'</tt>. For example:</p><pre><code>var pollA = new Ext.direct.PollingProvider({
 type:'polling',
 url: 'php/pollA.php',
 });
 Ext.Direct.addProvider(pollA);
 pollA.disconnect();

 Ext.Direct.addProvider(
 {
 type:'polling',
 url: 'php/pollB.php',
 id: 'pollB-provider'
 }
 );
 var pollB = Ext.Direct.getProvider('pollB-provider');
 </code></pre>
 *
 * <p>This class serves as a
 * typed config object for constructor of class PollingProvider.</p>
 *
 * <p>Copyright &#169; 2011 Sencha Inc.</p>
 * @see ext.direct.PollingProvider
 */
{ExtConfig:{target:"ext.direct.PollingProvider"}},
"public class pollingprovider extends ext.config.jsonprovider",5,function($$private){var $1=ext.config;return[ 

  "public function pollingprovider",function pollingprovider(config/*:Object = null*/) {if(arguments.length<=0)config=null;

     $1.jsonprovider.call(this,config);
  },


  /**
   An object containing properties which are to be sent as parameters on every polling request
   */
  "public native function get baseParams"/*():Object*/,

  /**
   * @private
   */
  "public native function set baseParams"/*(value:Object):void*/,

  /**
   How often to poll the server-side in milliseconds (defaults to <tt>3000</tt> - every 3 seconds).
   */
  "public native function get interval"/*():Number*/,

  /**
   * @private
   */
  "public native function set interval"/*(value:Number):void*/,

  /**
   Priority of the request (defaults to <tt>3</tt>). See <a href="output/Ext.direct.Provider.html#Ext.direct.Provider-priority">Ext.direct.Provider.priority</a>.
   */
  "override public native function get priority"/*():Number*/,

  /**
   * @private
   */
  "override public native function set priority"/*(value:Number):void*/,

  /**
   The url which the PollingProvider should contact with each request. This can also be an imported Ext.Direct method which will accept the baseParams as its only argument.
   */
  "public native function get url"/*():**/,

  /**
   * @private
   */
  "public native function set url"/*(value:*):void*/,


undefined];},[],["ext.config.jsonprovider"], "0.8.0", "0.9.12"
);