package flash.events {
import flash.display.InteractiveObject;
import flash.events.Event;

/**
 * A MouseEvent object is dispatched into the event flow whenever mouse events occur. A mouse event is usually generated by a user input device, such as a mouse or a trackball, that uses a pointer.
 * <p>When nested nodes are involved, mouse events target the deepest possible nested node that is visible in the display list. This node is called the <i>target node</i>. To have a target node's ancestor receive notification of a mouse event, use <code>EventDispatcher.addEventListener()</code> on the ancestor node with the <code>type</code> parameter set to the specific mouse event you want to detect.</p>
 * <p><a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/MouseEvent.html#includeExamplesSummary">View the examples</a></p>
 * @see http://help.adobe.com/en_US/Flex/4.0/UsingSDK/WS2db454920e96a9e51e63e3d11c0bf64a29-7ff8.html Handling keyboard-related mouse events
 *
 */
public class MouseEvent extends Event {
  /**
   * Indicates whether the Alt key is active (<code>true</code>) or inactive (<code>false</code>). Supported for Windows only. On other operating systems, this property is always set to <code>false</code>.
   */
  public native function get altKey():Boolean;

  /**
   * @private
   */
  public native function set altKey(value:Boolean):void;

  /**
   * Indicates whether the primary mouse button is pressed (<code>true</code>) or not (<code>false</code>).
   */
  public native function get buttonDown():Boolean;

  /**
   * @private
   */
  public native function set buttonDown(value:Boolean):void;

  /**
   * On Windows or Linux, indicates whether the Ctrl key is active (<code>true</code>) or inactive (<code>false</code>). On Macintosh, indicates whether either the Control key or the Command key is activated.
   */
  public native function get ctrlKey():Boolean;

  /**
   * @private
   */
  public native function set ctrlKey(value:Boolean):void;

  /**
   * Indicates how many lines should be scrolled for each unit the user rotates the mouse wheel. A positive delta value indicates an upward scroll; a negative value indicates a downward scroll. Typical values are 1 to 3, but faster rotation may produce larger values. This setting depends on the device and operating system and is usually configurable by the user. This property applies only to the <code>MouseEvent.mouseWheel</code> event.
   */
  public native function get delta():int;

  /**
   * @private
   */
  public native function set delta(value:int):void;

  /**
   * If <code>true</code>, the <code>relatedObject</code> property is set to <code>null</code> for reasons related to security sandboxes. If the nominal value of <code>relatedObject</code> is a reference to a DisplayObject in another sandbox, <code>relatedObject</code> is set to <code>null</code> unless there is permission in both directions across this sandbox boundary. Permission is established by calling <code>Security.allowDomain()</code> from a SWF file, or by providing a policy file from the server of an image file, and setting the <code>LoaderContext.checkPolicyFile</code> property when loading the image.
   * @see #relatedObject
   * @see flash.system.Security#allowDomain()
   * @see flash.system.LoaderContext#checkPolicyFile
   *
   */
  public native function get isRelatedObjectInaccessible():Boolean;

  /**
   * @private
   */
  public native function set isRelatedObjectInaccessible(value:Boolean):void;

  /**
   * The horizontal coordinate at which the event occurred relative to the containing sprite.
   * @example
   * <a href="http://www.adobe.com/go/learn_as3_usingexamples_en">How to use this example</a>Please see the <a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/MouseEvent.html#MOUSE_MOVE">MOUSE_MOVE</a> constant's example for an illustration of how to use this property.
   */
  public native function get localX():Number;

  /**
   * @private
   */
  public native function set localX(value:Number):void;

  /**
   * The vertical coordinate at which the event occurred relative to the containing sprite.
   * @example
   * <a href="http://www.adobe.com/go/learn_as3_usingexamples_en">How to use this example</a>Please see the <a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/MouseEvent.html#MOUSE_MOVE">MOUSE_MOVE</a> constant's example for an illustration of how to use this property.
   */
  public native function get localY():Number;

  /**
   * @private
   */
  public native function set localY(value:Number):void;

  /**
   * A reference to a display list object that is related to the event. For example, when a <code>mouseOut</code> event occurs, <code>relatedObject</code> represents the display list object to which the pointing device now points. This property applies to the <code>mouseOut</code>, <code>mouseOver</code>, <code>rollOut</code>, and <code>rollOver</code> events.
   * <p>The value of this property can be <code>null</code> in two circumstances: if there no related object, or there is a related object, but it is in a security sandbox to which you don't have access. Use the <code>isRelatedObjectInaccessible()</code> property to determine which of these reasons applies.</p>
   * @see #isRelatedObjectInaccessible
   *
   */
  public native function get relatedObject():InteractiveObject;

  /**
   * @private
   */
  public native function set relatedObject(value:InteractiveObject):void;

  /**
   * Indicates whether the Shift key is active (<code>true</code>) or inactive (<code>false</code>).
   */
  public native function get shiftKey():Boolean;

  /**
   * @private
   */
  public native function set shiftKey(value:Boolean):void;

  /**
   * The horizontal coordinate at which the event occurred in global Stage coordinates. This property is calculated when the <code>localX</code> property is set.
   * @example
   * <a href="http://www.adobe.com/go/learn_as3_usingexamples_en">How to use this example</a>Please see the <a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/MouseEvent.html#MOUSE_MOVE">MOUSE_MOVE</a> constant's example for an illustration of how to use this property.
   */
  public native function get stageX():Number;

  /**
   * The vertical coordinate at which the event occurred in global Stage coordinates. This property is calculated when the <code>localY</code> property is set.
   * @example
   * <a href="http://www.adobe.com/go/learn_as3_usingexamples_en">How to use this example</a>Please see the <a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/MouseEvent.html#MOUSE_MOVE">MOUSE_MOVE</a> constant's example for an illustration of how to use this property.
   */
  public native function get stageY():Number;

  /**
   * Creates an Event object that contains information about mouse events. Event objects are passed as parameters to event listeners.
   * @param type The type of the event. Possible values are: <code>MouseEvent.CLICK</code>, <code>MouseEvent.DOUBLE_CLICK</code>, <code>MouseEvent.MOUSE_DOWN</code>, <code>MouseEvent.MOUSE_MOVE</code>, <code>MouseEvent.MOUSE_OUT</code>, <code>MouseEvent.MOUSE_OVER</code>, <code>MouseEvent.MOUSE_UP</code>, <code>MouseEvent.MIDDLE_CLICK</code>, <code>MouseEvent.MIDDLE_MOUSE_DOWN</code>, <code>MouseEvent.MIDDLE_MOUSE_UP</code>, <code>MouseEvent.RIGHT_CLICK</code>, <code>MouseEvent.RIGHT_MOUSE_DOWN</code>, <code>MouseEvent.RIGHT_MOUSE_UP</code>, <code>MouseEvent.MOUSE_WHEEL</code>, <code>MouseEvent.ROLL_OUT</code>, and <code>MouseEvent.ROLL_OVER</code>.
   * @param bubbles Determines whether the Event object participates in the bubbling phase of the event flow.
   * @param cancelable Determines whether the Event object can be canceled.
   * @param localX The horizontal coordinate at which the event occurred relative to the containing sprite.
   * @param localY The vertical coordinate at which the event occurred relative to the containing sprite.
   * @param relatedObject The complementary InteractiveObject instance that is affected by the event. For example, when a <code>mouseOut</code> event occurs, <code>relatedObject</code> represents the display list object to which the pointing device now points.
   * @param ctrlKey On Windows or Linux, indicates whether the Ctrl key is activated. On Mac, indicates whether either the Ctrl key or the Command key is activated.
   * @param altKey Indicates whether the Alt key is activated (Windows or Linux only).
   * @param shiftKey Indicates whether the Shift key is activated.
   * @param buttonDown Indicates whether the primary mouse button is pressed.
   * @param delta Indicates how many lines should be scrolled for each unit the user rotates the mouse wheel. A positive delta value indicates an upward scroll; a negative value indicates a downward scroll. Typical values are 1 to 3, but faster rotation may produce larger values. This parameter is used only for the <code>MouseEvent.mouseWheel</code> event.
   * @param commandKey (AIR only) Indicates whether the Command key is activated (Mac only). This parameter is used only for the <code>MouseEvent.click</code>, <code>MouseEvent.mouseDown</code>, <code>MouseEvent.mouseUp</code>, <code>MouseEvent.middleClick</code>, <code>MouseEvent.middleMouseDown</code>, <code>MouseEvent.middleMouseUp</code>, <code>MouseEvent.rightClick</code>, <code>MouseEvent.rightMouseDown</code>, <code>MouseEvent.rightMouseUp</code>, and <code>MouseEvent.doubleClick</code> events. This parameter is for Adobe AIR only; do not set it for Flash Player content.
   * @param controlKey (AIR only) Indicates whether the Control or Ctrl key is activated. This parameter is used only for the <code>MouseEvent.click</code>, <code>MouseEvent.mouseDown</code>, <code>MouseEvent.mouseUp</code>, <code>MouseEvent.middleClick</code>, <code>MouseEvent.middleMouseDown</code>, <code>MouseEvent.middleMouseUp</code>, <code>MouseEvent.rightClick</code>, <code>MouseEvent.rightMouseDown</code>, <code>MouseEvent.rightMouseUp</code>, and <code>MouseEvent.doubleClick</code> events. This parameter is for Adobe AIR only; do not set it for Flash Player content.
   * @param clickCount (AIR only) Indicates whether or not the mouse event is part of a multi-click sequence. This parameter will be zero for all mouse events other than <code>MouseEvent.mouseDown</code>, <code>MouseEvent.mouseUp</code>, <code>MouseEvent.middleMouseDown</code>, <code>MouseEvent.middleMouseUp</code>, <code>MouseEvent.rightMouseDown</code> and <code>MouseEvent.rightMouseUp</code>. Listening for single clicks, double clicks, or any multi-click sequence is possible with the <code>clickCount</code> parameter. This parameter is for Adobe AIR only; do not set it for Flash Player content.
   *
   */
  public function MouseEvent(type:String, bubbles:Boolean = true, cancelable:Boolean = false, localX:Number = NaN, localY:Number = NaN, relatedObject:InteractiveObject = null, ctrlKey:Boolean = false, altKey:Boolean = false, shiftKey:Boolean = false, buttonDown:Boolean = false, delta:int = 0, commandKey:Boolean = false, controlKey:Boolean = false, clickCount:int = 0){super(null);}

  /**
   * Creates a copy of the MouseEvent object and sets the value of each property to match that of the original.
   * @return A new MouseEvent object with property values that match those of the original.
   *
   */
  override public native function clone():Event;

  /**
   * Returns a string that contains all the properties of the MouseEvent object. The string is in the following format:
   * <p><code>[MouseEvent type=<i>value</i> bubbles=<i>value</i> cancelable=<i>value</i> ... delta=<i>value</i>]</code></p>
   * @return A string that contains all the properties of the MouseEvent object.
   *
   */
  override public native function toString():String;

  /**
   * Instructs Flash Player or Adobe AIR to render after processing of this event completes, if the display list has been modified.
   */
  public native function updateAfterEvent():void;

  /**
   * Defines the value of the <code>type</code> property of a <code>click</code> event object.
   * <p>This event has the following properties:</p>
   * <table>
   * <tr><th>Property</th><th>Value</th></tr>
   * <tr>
   * <td><code>altKey</code></td>
   * <td><code>true</code> if the Alt key is active (Windows).</td></tr>
   * <tr>
   * <td><code>bubbles</code></td>
   * <td><code>true</code></td></tr>
   * <tr>
   * <td><code>buttonDown</code></td>
   * <td>For click events, this value is always <code>false</code>.</td></tr>
   * <tr>
   * <td><code>cancelable</code></td>
   * <td><code>false</code>; there is no default behavior to cancel.</td></tr>
   * <tr>
   * <td><code>commandKey</code></td>
   * <td><code>true</code> on the Mac if the Command key is active; <code>false</code> if it is inactive. Always <code>false</code> on Windows.</td></tr>
   * <tr>
   * <td><code>controlKey</code></td>
   * <td><code>true</code> if the Ctrl or Control key is active; <code>false</code> if it is inactive.</td></tr>
   * <tr>
   * <td><code>ctrlKey</code></td>
   * <td><code>true</code> on Windows or Linux if the Ctrl key is active. <code>true</code> on Mac if either the Ctrl key or the Command key is active. Otherwise, <code>false</code>.</td></tr>
   * <tr>
   * <td><code>currentTarget</code></td>
   * <td>The object that is actively processing the Event object with an event listener.</td></tr>
   * <tr>
   * <td><code>localX</code></td>
   * <td>The horizontal coordinate at which the event occurred relative to the containing sprite.</td></tr>
   * <tr>
   * <td><code>localY</code></td>
   * <td>The vertical coordinate at which the event occurred relative to the containing sprite.</td></tr>
   * <tr>
   * <td><code>shiftKey</code></td>
   * <td><code>true</code> if the Shift key is active; <code>false</code> if it is inactive.</td></tr>
   * <tr>
   * <td><code>stageX</code></td>
   * <td>The horizontal coordinate at which the event occurred in global stage coordinates.</td></tr>
   * <tr>
   * <td><code>stageY</code></td>
   * <td>The vertical coordinate at which the event occurred in global stage coordinates.</td></tr>
   * <tr>
   * <td><code>target</code></td>
   * <td>The InteractiveObject instance under the pointing device. The <code>target</code> is not always the object in the display list that registered the event listener. Use the <code>currentTarget</code> property to access the object in the display list that is currently processing the event.</td></tr></table>
   * @see flash.display.InteractiveObject#event:click
   *
   */
  public static const CLICK:String = "click";
  /**
   * Defines the value of the <code>type</code> property of a <code>doubleClick</code> event object. The <code>doubleClickEnabled</code> property must be <code>true</code> for an object to generate the <code>doubleClick</code> event.
   * <p>This event has the following properties:</p>
   * <table>
   * <tr><th>Property</th><th>Value</th></tr>
   * <tr>
   * <td><code>altKey</code></td>
   * <td><code>true</code> if the Alt key is active (Windows).</td></tr>
   * <tr>
   * <td><code>bubbles</code></td>
   * <td><code>true</code></td></tr>
   * <tr>
   * <td><code>buttonDown</code></td>
   * <td>For double-click events, this value is always <code>false</code>.</td></tr>
   * <tr>
   * <td><code>cancelable</code></td>
   * <td><code>false</code>; there is no default behavior to cancel.</td></tr>
   * <tr>
   * <td><code>commandKey</code></td>
   * <td><code>true</code> on the Mac if the Command key is active; <code>false</code> if it is inactive. Always <code>false</code> on Windows.</td></tr>
   * <tr>
   * <td><code>controlKey</code></td>
   * <td><code>true</code> if the Ctrl or Control key is active; <code>false</code> if it is inactive.</td></tr>
   * <tr>
   * <td><code>ctrlKey</code></td>
   * <td><code>true</code> on Windows or Linux if the Ctrl key is active. <code>true</code> on Mac if either the Ctrl key or the Command key is active. Otherwise, <code>false</code>.</td></tr>
   * <tr>
   * <td><code>currentTarget</code></td>
   * <td>The object that is actively processing the Event object with an event listener.</td></tr>
   * <tr>
   * <td><code>localX</code></td>
   * <td>The horizontal coordinate at which the event occurred relative to the containing sprite.</td></tr>
   * <tr>
   * <td><code>localY</code></td>
   * <td>The vertical coordinate at which the event occurred relative to the containing sprite.</td></tr>
   * <tr>
   * <td><code>shiftKey</code></td>
   * <td><code>true</code> if the Shift key is active; <code>false</code> if it is inactive.</td></tr>
   * <tr>
   * <td><code>stageX</code></td>
   * <td>The horizontal coordinate at which the event occurred in global stage coordinates.</td></tr>
   * <tr>
   * <td><code>stageY</code></td>
   * <td>The vertical coordinate at which the event occurred in global stage coordinates.</td></tr>
   * <tr>
   * <td><code>target</code></td>
   * <td>The InteractiveObject instance under the pointing device. The <code>target</code> is not always the object in the display list that registered the event listener. Use the <code>currentTarget</code> property to access the object in the display list that is currently processing the event.</td></tr></table>
   * @see flash.display.InteractiveObject#event:doubleClick
   *
   */
  public static const DOUBLE_CLICK:String = "doubleClick";
  /**
   * Defines the value of the <code>type</code> property of a <code>mouseDown</code> event object.
   * <p>This event has the following properties:</p>
   * <table>
   * <tr><th>Property</th><th>Value</th></tr>
   * <tr>
   * <td><code>altKey</code></td>
   * <td><code>true</code> if the Alt key is active (Windows).</td></tr>
   * <tr>
   * <td><code>bubbles</code></td>
   * <td><code>true</code></td></tr>
   * <tr>
   * <td><code>buttonDown</code></td>
   * <td><code>true</code> if the primary mouse button is pressed; <code>false</code> otherwise.</td></tr>
   * <tr>
   * <td><code>cancelable</code></td>
   * <td><code>false</code>; the default behavior cannot be canceled.</td></tr>
   * <tr>
   * <td><code>commandKey</code></td>
   * <td><code>true</code> on the Mac if the Command key is active; <code>false</code> if it is inactive. Always <code>false</code> on Windows.</td></tr>
   * <tr>
   * <td><code>controlKey</code></td>
   * <td><code>true</code> if the Ctrl or Control key is active; <code>false</code> if it is inactive.</td></tr>
   * <tr>
   * <td><code>ctrlKey</code></td>
   * <td><code>true</code> on Windows and Linux if the Ctrl key is active. <code>true</code> on Mac if either the Ctrl key or the Command key is active. Otherwise, <code>false</code>.</td></tr>
   * <tr>
   * <td><code>currentTarget</code></td>
   * <td>The object that is actively processing the Event object with an event listener.</td></tr>
   * <tr>
   * <td><code>localX</code></td>
   * <td>The horizontal coordinate at which the event occurred relative to the containing sprite.</td></tr>
   * <tr>
   * <td><code>localY</code></td>
   * <td>The vertical coordinate at which the event occurred relative to the containing sprite.</td></tr>
   * <tr>
   * <td><code>shiftKey</code></td>
   * <td><code>true</code> if the Shift key is active; <code>false</code> if it is inactive.</td></tr>
   * <tr>
   * <td><code>clickCount</code></td>
   * <td>Count of the number of mouse clicks to indicate whether the event is part of a multi-click sequence.</td></tr>
   * <tr>
   * <td><code>stageX</code></td>
   * <td>The horizontal coordinate at which the event occurred in global stage coordinates.</td></tr>
   * <tr>
   * <td><code>stageY</code></td>
   * <td>The vertical coordinate at which the event occurred in global stage coordinates.</td></tr>
   * <tr>
   * <td><code>target</code></td>
   * <td>The InteractiveObject instance under the pointing device. The <code>target</code> is not always the object in the display list that registered the event listener. Use the <code>currentTarget</code> property to access the object in the display list that is currently processing the event.</td></tr></table>
   * @see flash.display.InteractiveObject#event:mouseDown
   *
   * @example
   * <a href="http://www.adobe.com/go/learn_as3_usingexamples_en">How to use this example</a>Please see the <a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/MouseEvent.html#MOUSE_MOVE">MOUSE_MOVE</a> constant's example for an illustration of how to use this constant.
   */
  public static const MOUSE_DOWN:String = "mouseDown";
  /**
   * Defines the value of the <code>type</code> property of a <code>mouseMove</code> event object.
   * <p>This event has the following properties:</p>
   * <table>
   * <tr><th>Property</th><th>Value</th></tr>
   * <tr>
   * <td><code>altKey</code></td>
   * <td><code>true</code> if the Alt key is active (Windows).</td></tr>
   * <tr>
   * <td><code>bubbles</code></td>
   * <td><code>true</code></td></tr>
   * <tr>
   * <td><code>buttonDown</code></td>
   * <td><code>true</code> if the primary mouse button is pressed; <code>false</code> otherwise.</td></tr>
   * <tr>
   * <td><code>cancelable</code></td>
   * <td><code>false</code>; the default behavior cannot be canceled.</td></tr>
   * <tr>
   * <td><code>commandKey</code></td>
   * <td><code>true</code> on the Mac if the Command key is active; <code>false</code> if it is inactive. Always <code>false</code> on Windows.</td></tr>
   * <tr>
   * <td><code>controlKey</code></td>
   * <td><code>true</code> if the Ctrl or Control key is active; <code>false</code> if it is inactive.</td></tr>
   * <tr>
   * <td><code>ctrlKey</code></td>
   * <td><code>true</code> on Windows or Linux if the Ctrl key is active. <code>true</code> on Mac if either the Ctrl key or the Command key is active. Otherwise, <code>false</code>.</td></tr>
   * <tr>
   * <td><code>currentTarget</code></td>
   * <td>The object that is actively processing the Event object with an event listener.</td></tr>
   * <tr>
   * <td><code>localX</code></td>
   * <td>The horizontal coordinate at which the event occurred relative to the containing sprite.</td></tr>
   * <tr>
   * <td><code>localY</code></td>
   * <td>The vertical coordinate at which the event occurred relative to the containing sprite.</td></tr>
   * <tr>
   * <td><code>shiftKey</code></td>
   * <td><code>true</code> if the Shift key is active; <code>false</code> if it is inactive.</td></tr>
   * <tr>
   * <td><code>stageX</code></td>
   * <td>The horizontal coordinate at which the event occurred in global stage coordinates.</td></tr>
   * <tr>
   * <td><code>stageY</code></td>
   * <td>The vertical coordinate at which the event occurred in global stage coordinates.</td></tr>
   * <tr>
   * <td><code>target</code></td>
   * <td>The InteractiveObject instance under the pointing device. The <code>target</code> is not always the object in the display list that registered the event listener. Use the <code>currentTarget</code> property to access the object in the display list that is currently processing the event.</td></tr></table>
   * @see flash.display.InteractiveObject#event:mouseMove
   *
   * @example The following example is a simple drawing program. The user can draw on the main Sprite object or on a smaller rectangular Sprite object.
   * <p>In the constructor, a rectangle <code>innerRect</code> Sprite object is created and the line style is set to green. The line style for drawing on the <code>MouseEvent_MOUSE_MOVEExample</code> Sprite container is set to red. Separate event listeners for the <code>MouseEvent.MOUSE_UP</code> and <code>MouseEvent.MOUSE_DOWN</code> events are added for the application's main Sprite object and <code>innerRect</code> Sprite object. In both cases, the mouse down event listener methods move the current drawing position to the mouse pointer's location and add a listener for the <code>MouseEvent.MOUSE_MOVE</code> event. When the mouse pointer is moved, the invoked event listener methods follows the pointer and draw a line using the <code>graphics.LineTo()</code> method. (<b>Note:</b> The <code>innerRect</code> Sprite object obscures the red lines of the main Sprite object that are drawn behind the rectangle.) When the <code>MouseEvent.MOUSE_UP</code> event occurs, the listener for the <code>MOUSE_MOVE</code> event is removed and drawing is stopped.</p>
   * <listing>
   * package {
   *     import flash.display.Sprite;
   *     import flash.display.Graphics;
   *     import flash.events.MouseEvent;
   *
   *     public class MouseEvent_MOUSE_MOVEExample extends Sprite {
   *         private var innerRect:Sprite = new Sprite();
   *
   *         public function MouseEvent_MOUSE_MOVEExample() {
   *
   *             graphics.lineStyle(3, 0xFF0000, 1);
   *             stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
   *             stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
   *
   *             innerRect.graphics.lineStyle(1, 0x00FF00, 1);
   *             innerRect.graphics.beginFill(0xFFFFFF);
   *             innerRect.graphics.drawRect(10, 10, 200, 200);
   *             innerRect.graphics.endFill();
   *             innerRect.addEventListener(MouseEvent.MOUSE_DOWN, innerRectMouseDownHandler);
   *             innerRect.addEventListener(MouseEvent.MOUSE_UP, innerRectMouseUpHandler);
   *             addChild(innerRect);
   *         }
   *
   *         private function mouseDownHandler(event:MouseEvent):void {
   *             graphics.moveTo(event.stageX, event.stageY);
   *             stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
   *         }
   *
   *         private function mouseMoveHandler(event:MouseEvent):void {
   *             graphics.lineTo(event.stageX, event.stageY);
   *         }
   *
   *         private function mouseUpHandler(event:MouseEvent):void {
   *             stage.removeEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
   *         }
   *
   *         private function innerRectMouseDownHandler(event:MouseEvent):void {
   *             innerRect.graphics.moveTo(event.localX, event.localY);
   *             innerRect.addEventListener(MouseEvent.MOUSE_MOVE, innerRectMouseMoveHandler);
   *         }
   *
   *         private function innerRectMouseMoveHandler(event:MouseEvent):void {
   *             innerRect.graphics.lineTo(event.localX, event.localY);
   *         }
   *
   *         private function innerRectMouseUpHandler(event:MouseEvent):void {
   *             innerRect.removeEventListener(MouseEvent.MOUSE_MOVE, innerRectMouseMoveHandler);
   *         }
   *     }
   * }
   * </listing>
   */
  public static const MOUSE_MOVE:String = "mouseMove";
  /**
   * Defines the value of the <code>type</code> property of a <code>mouseOut</code> event object.
   * <p>This event has the following properties:</p>
   * <table>
   * <tr><th>Property</th><th>Value</th></tr>
   * <tr>
   * <td><code>altKey</code></td>
   * <td><code>true</code> if the Alt key is active (Windows).</td></tr>
   * <tr>
   * <td><code>bubbles</code></td>
   * <td><code>true</code></td></tr>
   * <tr>
   * <td><code>buttonDown</code></td>
   * <td><code>true</code> if the primary mouse button is pressed; <code>false</code> otherwise.</td></tr>
   * <tr>
   * <td><code>cancelable</code></td>
   * <td><code>false</code>; the default behavior cannot be canceled.</td></tr>
   * <tr>
   * <td><code>commandKey</code></td>
   * <td><code>true</code> on the Mac if the Command key is active; <code>false</code> if it is inactive. Always <code>false</code> on Windows.</td></tr>
   * <tr>
   * <td><code>controlKey</code></td>
   * <td><code>true</code> if the Ctrl or Control key is active; <code>false</code> if it is inactive.</td></tr>
   * <tr>
   * <td><code>ctrlKey</code></td>
   * <td><code>true</code> on Windows or Linux if the Ctrl key is active. <code>true</code> on Mac if either the Ctrl key or the Command key is active. Otherwise, <code>false</code>.</td></tr>
   * <tr>
   * <td><code>currentTarget</code></td>
   * <td>The object that is actively processing the Event object with an event listener.</td></tr>
   * <tr>
   * <td><code>relatedObject</code></td>
   * <td>The display list object to which the pointing device now points.</td></tr>
   * <tr>
   * <td><code>localX</code></td>
   * <td>The horizontal coordinate at which the event occurred relative to the containing sprite.</td></tr>
   * <tr>
   * <td><code>localY</code></td>
   * <td>The vertical coordinate at which the event occurred relative to the containing sprite.</td></tr>
   * <tr>
   * <td><code>shiftKey</code></td>
   * <td><code>true</code> if the Shift key is active; <code>false</code> if it is inactive.</td></tr>
   * <tr>
   * <td><code>stageX</code></td>
   * <td>The horizontal coordinate at which the event occurred in global stage coordinates.</td></tr>
   * <tr>
   * <td><code>stageY</code></td>
   * <td>The vertical coordinate at which the event occurred in global stage coordinates.</td></tr>
   * <tr>
   * <td><code>target</code></td>
   * <td>The InteractiveObject instance under the pointing device. The <code>target</code> is not always the object in the display list that registered the event listener. Use the <code>currentTarget</code> property to access the object in the display list that is currently processing the event.</td></tr></table>
   * @see flash.display.InteractiveObject#event:mouseOut
   *
   */
  public static const MOUSE_OUT:String = "mouseOut";
  /**
   * Defines the value of the <code>type</code> property of a <code>mouseOver</code> event object.
   * <p>This event has the following properties:</p>
   * <table>
   * <tr><th>Property</th><th>Value</th></tr>
   * <tr>
   * <td><code>altKey</code></td>
   * <td><code>true</code> if the Alt key is active (Windows).</td></tr>
   * <tr>
   * <td><code>bubbles</code></td>
   * <td><code>true</code></td></tr>
   * <tr>
   * <td><code>buttonDown</code></td>
   * <td><code>true</code> if the primary mouse button is pressed; <code>false</code> otherwise.</td></tr>
   * <tr>
   * <td><code>cancelable</code></td>
   * <td><code>false</code>; the default behavior cannot be canceled.</td></tr>
   * <tr>
   * <td><code>commandKey</code></td>
   * <td><code>true</code> on the Mac if the Command key is active; <code>false</code> if it is inactive. Always <code>false</code> on Windows.</td></tr>
   * <tr>
   * <td><code>controlKey</code></td>
   * <td><code>true</code> if the Ctrl or Control key is active; <code>false</code> if it is inactive.</td></tr>
   * <tr>
   * <td><code>ctrlKey</code></td>
   * <td><code>true</code> on Windows or Linux if the Ctrl key is active. <code>true</code> on Mac if either the Ctrl key or the Command key is active. Otherwise, <code>false</code>.</td></tr>
   * <tr>
   * <td><code>currentTarget</code></td>
   * <td>The object that is actively processing the Event object with an event listener.</td></tr>
   * <tr>
   * <td><code>relatedObject</code></td>
   * <td>The display list object to which the pointing device was pointing.</td></tr>
   * <tr>
   * <td><code>localX</code></td>
   * <td>The horizontal coordinate at which the event occurred relative to the containing sprite.</td></tr>
   * <tr>
   * <td><code>localY</code></td>
   * <td>The vertical coordinate at which the event occurred relative to the containing sprite.</td></tr>
   * <tr>
   * <td><code>shiftKey</code></td>
   * <td><code>true</code> if the Shift key is active; <code>false</code> if it is inactive.</td></tr>
   * <tr>
   * <td><code>stageX</code></td>
   * <td>The horizontal coordinate at which the event occurred in global stage coordinates.</td></tr>
   * <tr>
   * <td><code>stageY</code></td>
   * <td>The vertical coordinate at which the event occurred in global stage coordinates.</td></tr>
   * <tr>
   * <td><code>target</code></td>
   * <td>The InteractiveObject instance under the pointing device. The <code>target</code> is not always the object in the display list that registered the event listener. Use the <code>currentTarget</code> property to access the object in the display list that is currently processing the event.</td></tr></table>
   * @see flash.display.InteractiveObject#event:mouseOver
   *
   */
  public static const MOUSE_OVER:String = "mouseOver";
  /**
   * Defines the value of the <code>type</code> property of a <code>mouseUp</code> event object.
   * <p>This event has the following properties:</p>
   * <table>
   * <tr><th>Property</th><th>Value</th></tr>
   * <tr>
   * <td><code>altKey</code></td>
   * <td><code>true</code> if the Alt key is active (Windows).</td></tr>
   * <tr>
   * <td><code>bubbles</code></td>
   * <td><code>true</code></td></tr>
   * <tr>
   * <td><code>buttonDown</code></td>
   * <td><code>true</code> if the primary mouse button is pressed; <code>false</code> otherwise.</td></tr>
   * <tr>
   * <td><code>cancelable</code></td>
   * <td><code>false</code>; the default behavior cannot be canceled.</td></tr>
   * <tr>
   * <td><code>commandKey</code></td>
   * <td><code>true</code> on the Mac if the Command key is active; <code>false</code> if it is inactive. Always <code>false</code> on Windows.</td></tr>
   * <tr>
   * <td><code>controlKey</code></td>
   * <td><code>true</code> if the Ctrl or Control key is active; <code>false</code> if it is inactive.</td></tr>
   * <tr>
   * <td><code>ctrlKey</code></td>
   * <td><code>true</code> on Windows or Linux if the Ctrl key is active. <code>true</code> on Mac if either the Ctrl key or the Command key is active. Otherwise, <code>false</code>.</td></tr>
   * <tr>
   * <td><code>currentTarget</code></td>
   * <td>The object that is actively processing the Event object with an event listener.</td></tr>
   * <tr>
   * <td><code>localX</code></td>
   * <td>The horizontal coordinate at which the event occurred relative to the containing sprite.</td></tr>
   * <tr>
   * <td><code>localY</code></td>
   * <td>The vertical coordinate at which the event occurred relative to the containing sprite.</td></tr>
   * <tr>
   * <td><code>shiftKey</code></td>
   * <td><code>true</code> if the Shift key is active; <code>false</code> if it is inactive.</td></tr>
   * <tr>
   * <td><code>clickCount</code></td>
   * <td>Count of the number of mouse clicks to indicate whether the event is part of a multi-click sequence.</td></tr>
   * <tr>
   * <td><code>stageX</code></td>
   * <td>The horizontal coordinate at which the event occurred in global stage coordinates.</td></tr>
   * <tr>
   * <td><code>stageY</code></td>
   * <td>The vertical coordinate at which the event occurred in global stage coordinates.</td></tr>
   * <tr>
   * <td><code>target</code></td>
   * <td>The InteractiveObject instance under the pointing device. The <code>target</code> is not always the object in the display list that registered the event listener. Use the <code>currentTarget</code> property to access the object in the display list that is currently processing the event.</td></tr></table>
   * @see flash.display.InteractiveObject#event:mouseUp
   *
   * @example
   * <a href="http://www.adobe.com/go/learn_as3_usingexamples_en">How to use this example</a>Please see the <a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/MouseEvent.html#MOUSE_MOVE">MOUSE_MOVE</a> constant's example for an illustration of how to use this constant.
   */
  public static const MOUSE_UP:String = "mouseUp";
  /**
   * Defines the value of the <code>type</code> property of a <code>mouseWheel</code> event object.
   * <p>This event has the following properties:</p>
   * <table>
   * <tr><th>Property</th><th>Value</th></tr>
   * <tr>
   * <td><code>altKey</code></td>
   * <td><code>true</code> if the Alt key is active (Windows).</td></tr>
   * <tr>
   * <td><code>bubbles</code></td>
   * <td><code>true</code></td></tr>
   * <tr>
   * <td><code>buttonDown</code></td>
   * <td><code>true</code> if the primary mouse button is pressed; <code>false</code> otherwise.</td></tr>
   * <tr>
   * <td><code>cancelable</code></td>
   * <td><code>false</code>; the default behavior cannot be canceled.</td></tr>
   * <tr>
   * <td><code>commandKey</code></td>
   * <td><code>true</code> on the Mac if the Command key is active; <code>false</code> if it is inactive. Always <code>false</code> on Windows.</td></tr>
   * <tr>
   * <td><code>controlKey</code></td>
   * <td><code>true</code> if the Ctrl or Control key is active; <code>false</code> if it is inactive.</td></tr>
   * <tr>
   * <td><code>ctrlKey</code></td>
   * <td><code>true</code> on Windows or Linux if the Ctrl key is active. <code>true</code> on Mac if either the Ctrl key or the Command key is active. Otherwise, <code>false</code>.</td></tr>
   * <tr>
   * <td><code>currentTarget</code></td>
   * <td>The object that is actively processing the Event object with an event listener.</td></tr>
   * <tr>
   * <td><code>delta</code></td>
   * <td>The number of lines that that each notch on the mouse wheel represents.</td></tr>
   * <tr>
   * <td><code>localX</code></td>
   * <td>The horizontal coordinate at which the event occurred relative to the containing sprite.</td></tr>
   * <tr>
   * <td><code>localY</code></td>
   * <td>The vertical coordinate at which the event occurred relative to the containing sprite.</td></tr>
   * <tr>
   * <td><code>shiftKey</code></td>
   * <td><code>true</code> if the Shift key is active; <code>false</code> if it is inactive.</td></tr>
   * <tr>
   * <td><code>stageX</code></td>
   * <td>The horizontal coordinate at which the event occurred in global stage coordinates.</td></tr>
   * <tr>
   * <td><code>stageY</code></td>
   * <td>The vertical coordinate at which the event occurred in global stage coordinates.</td></tr>
   * <tr>
   * <td><code>target</code></td>
   * <td>The InteractiveObject instance under the pointing device. The <code>target</code> is not always the object in the display list that registered the event listener. Use the <code>currentTarget</code> property to access the object in the display list that is currently processing the event.</td></tr></table>
   * @see flash.display.InteractiveObject#event:mouseWheel
   *
   */
  public static const MOUSE_WHEEL:String = "mouseWheel";
  /**
   * Defines the value of the <code>type</code> property of a <code>rollOut</code> event object.
   * <p>This event has the following properties:</p>
   * <table>
   * <tr><th>Property</th><th>Value</th></tr>
   * <tr>
   * <td><code>altKey</code></td>
   * <td><code>true</code> if the Alt key is active (Windows).</td></tr>
   * <tr>
   * <td><code>bubbles</code></td>
   * <td><code>false</code></td></tr>
   * <tr>
   * <td><code>buttonDown</code></td>
   * <td><code>true</code> if the primary mouse button is pressed; <code>false</code> otherwise.</td></tr>
   * <tr>
   * <td><code>cancelable</code></td>
   * <td><code>false</code>; there is no default behavior to cancel.</td></tr>
   * <tr>
   * <td><code>commandKey</code></td>
   * <td><code>true</code> on the Mac if the Command key is active; <code>false</code> if it is inactive. Always <code>false</code> on Windows.</td></tr>
   * <tr>
   * <td><code>controlKey</code></td>
   * <td><code>true</code> if the Ctrl or Control key is active; <code>false</code> if it is inactive.</td></tr>
   * <tr>
   * <td><code>ctrlKey</code></td>
   * <td><code>true</code> on Windows or Linux if the Ctrl key is active. <code>true</code> on Mac if either the Ctrl key or the Command key is active. Otherwise, <code>false</code>.</td></tr>
   * <tr>
   * <td><code>currentTarget</code></td>
   * <td>The object that is actively processing the Event object with an event listener.</td></tr>
   * <tr>
   * <td><code>relatedObject</code></td>
   * <td>The display list object to which the pointing device now points.</td></tr>
   * <tr>
   * <td><code>localX</code></td>
   * <td>The horizontal coordinate at which the event occurred relative to the containing sprite.</td></tr>
   * <tr>
   * <td><code>localY</code></td>
   * <td>The vertical coordinate at which the event occurred relative to the containing sprite.</td></tr>
   * <tr>
   * <td><code>shiftKey</code></td>
   * <td><code>true</code> if the Shift key is active; <code>false</code> if it is inactive.</td></tr>
   * <tr>
   * <td><code>stageX</code></td>
   * <td>The horizontal coordinate at which the event occurred in global stage coordinates.</td></tr>
   * <tr>
   * <td><code>stageY</code></td>
   * <td>The vertical coordinate at which the event occurred in global stage coordinates.</td></tr>
   * <tr>
   * <td><code>target</code></td>
   * <td>The InteractiveObject instance under the pointing device. The <code>target</code> is not always the object in the display list that registered the event listener. Use the <code>currentTarget</code> property to access the object in the display list that is currently processing the event.</td></tr></table>
   * @see flash.display.InteractiveObject#event:rollOut
   *
   */
  public static const ROLL_OUT:String = "rollOut";
  /**
   * Defines the value of the <code>type</code> property of a <code>rollOver</code> event object.
   * <p>This event has the following properties:</p>
   * <table>
   * <tr><th>Property</th><th>Value</th></tr>
   * <tr>
   * <td><code>altKey</code></td>
   * <td><code>true</code> if the Alt key is active (Windows).</td></tr>
   * <tr>
   * <td><code>bubbles</code></td>
   * <td><code>false</code></td></tr>
   * <tr>
   * <td><code>buttonDown</code></td>
   * <td><code>true</code> if the primary mouse button is pressed; <code>false</code> otherwise.</td></tr>
   * <tr>
   * <td><code>cancelable</code></td>
   * <td><code>false</code>; there is no default behavior to cancel.</td></tr>
   * <tr>
   * <td><code>commandKey</code></td>
   * <td><code>true</code> on the Mac if the Command key is active; <code>false</code> if it is inactive. Always <code>false</code> on Windows.</td></tr>
   * <tr>
   * <td><code>controlKey</code></td>
   * <td><code>true</code> if the Ctrl or Control key is active; <code>false</code> if it is inactive.</td></tr>
   * <tr>
   * <td><code>ctrlKey</code></td>
   * <td><code>true</code> on Windows or Linux if the Ctrl key is active. <code>true</code> on Mac if either the Ctrl key or the Command key is active. Otherwise, <code>false</code>.</td></tr>
   * <tr>
   * <td><code>currentTarget</code></td>
   * <td>The object that is actively processing the Event object with an event listener.</td></tr>
   * <tr>
   * <td><code>relatedObject</code></td>
   * <td>The display list object to which the pointing device was pointing.</td></tr>
   * <tr>
   * <td><code>localX</code></td>
   * <td>The horizontal coordinate at which the event occurred relative to the containing sprite.</td></tr>
   * <tr>
   * <td><code>localY</code></td>
   * <td>The vertical coordinate at which the event occurred relative to the containing sprite.</td></tr>
   * <tr>
   * <td><code>shiftKey</code></td>
   * <td><code>true</code> if the Shift key is active; <code>false</code> if it is inactive.</td></tr>
   * <tr>
   * <td><code>stageX</code></td>
   * <td>The horizontal coordinate at which the event occurred in global stage coordinates.</td></tr>
   * <tr>
   * <td><code>stageY</code></td>
   * <td>The vertical coordinate at which the event occurred in global stage coordinates.</td></tr>
   * <tr>
   * <td><code>target</code></td>
   * <td>The InteractiveObject instance under the pointing device. The <code>target</code> is not always the object in the display list that registered the event listener. Use the <code>currentTarget</code> property to access the object in the display list that is currently processing the event.</td></tr></table>
   * @see flash.display.InteractiveObject#event:rollOver
   *
   */
  public static const ROLL_OVER:String = "rollOver";
}
}