package flash.net {


/**
 * The NetStreamMulticastInfo class specifies various Quality of Service (QoS) statistics related to a NetStream object's underlying RTMFP Peer-to-Peer and IP Multicast stream transport. A NetStreamMulticastInfo object is returned by the <code>NetStream.multicastInfo</code> property.
 * <p>Properties that return numbers represent totals computed from the beginning of the multicast stream. These types of properties include the number of media bytes sent or the number of media fragment messages received. Properties that are rates represent a snapshot of the current rate averaged over a few seconds. These types of properties include the rate at which a local node is receiving data.</p>
 * <p>To see a list of values contained in the NetStreamMulticastInfo object, use the <code>NetStreamMulticastInfo.toString()</code> method.</p>
 * @see #toString()
 * @see NetStream#multicastInfo
 *
 */
public final class NetStreamMulticastInfo {
  /**
   * Specifies the number of media bytes that were proactively pushed from peers and received by the local node.
   * @see #bytesRequestedFromPeers
   * @see #fragmentsPushedFromPeers
   * @see #fragmentsRequestedFromPeers
   *
   */
  public native function get bytesPushedFromPeers():Number;

  /**
   * Specifies the number of media bytes that the local node has proactively pushed to peers.
   * @see #bytesRequestedByPeers
   * @see #fragmentsPushedToPeers
   * @see #fragmentsRequestedByPeers
   *
   */
  public native function get bytesPushedToPeers():Number;

  /**
   * Specifies the number of media bytes that the local node has received from IP Multicast.
   * @see #bytesReceivedFromServer
   * @see #fragmentsReceivedFromIPMulticast
   * @see #fragmentsReceivedFromServer
   * @see #receiveDataBytesPerSecondFromIPMulticast
   *
   */
  public native function get bytesReceivedFromIPMulticast():Number;

  /**
   * Specifies the number of media bytes that the local node has received from the server.
   * @see #bytesReceivedFromIPMulticast
   * @see #fragmentsReceivedFromIPMulticast
   * @see #fragmentsReceivedFromServer
   * @see #receiveDataBytesPerSecondFromServer
   *
   */
  public native function get bytesReceivedFromServer():Number;

  /**
   * Specifies the number of media bytes that the local node has sent to peers in response to requests from those peers for specific fragments.
   * @see #bytesPushedToPeers
   * @see #fragmentsPushedToPeers
   * @see #fragmentsRequestedByPeers
   *
   */
  public native function get bytesRequestedByPeers():Number;

  /**
   * Specifies the number of media bytes that the local node requested and received from peers.
   * @see #bytesPushedFromPeers
   * @see #fragmentsPushedFromPeers
   * @see #fragmentsRequestedFromPeers
   *
   */
  public native function get bytesRequestedFromPeers():Number;

  /**
   * Specifies the number of media fragment messages that were proactively pushed from peers and received by the local node.
   * @see #bytesPushedFromPeers
   * @see #bytesRequestedFromPeers
   * @see #fragmentsRequestedFromPeers
   *
   */
  public native function get fragmentsPushedFromPeers():Number;

  /**
   * Specifies the number of media fragment messages that the local node has proactively pushed to peers.
   * @see #bytesPushedToPeers
   * @see #bytesRequestedByPeers
   * @see #fragmentsRequestedByPeers
   *
   */
  public native function get fragmentsPushedToPeers():Number;

  /**
   * Specifies the number of media fragment messages that the local node has received from IP Multicast.
   * @see #bytesReceivedFromIPMulticast
   * @see #bytesReceivedFromServer
   * @see #fragmentsReceivedFromServer
   * @see #receiveDataBytesPerSecondFromIPMulticast
   *
   */
  public native function get fragmentsReceivedFromIPMulticast():Number;

  /**
   * Specifies the number of media fragment messages that the local node has received from the server.
   * @see #bytesReceivedFromIPMulticast
   * @see #bytesReceivedFromServer
   * @see #fragmentsReceivedFromIPMulticast
   * @see #receiveDataBytesPerSecondFromServer
   *
   */
  public native function get fragmentsReceivedFromServer():Number;

  /**
   * Specifies the number of media fragment messages that the local node has sent to peers in response to requests from those peers for specific fragments.
   * @see #bytesPushedToPeers
   * @see #bytesRequestedByPeers
   * @see #fragmentsPushedToPeers
   *
   */
  public native function get fragmentsRequestedByPeers():Number;

  /**
   * Specifies the number of media fragment messages that the local node requested and received from peers.
   * @see #bytesPushedFromPeers
   * @see #bytesRequestedFromPeers
   * @see #fragmentsPushedFromPeers
   *
   */
  public native function get fragmentsRequestedFromPeers():Number;

  /**
   * Specifies the rate at which the local node is receiving control overhead messages from peers, in bytes per second.
   * @see #receiveDataBytesPerSecond
   * @see #receiveDataBytesPerSecondFromServer
   * @see #receiveDataBytesPerSecondFromIPMulticast
   * @see #sendControlBytesPerSecond
   *
   */
  public native function get receiveControlBytesPerSecond():Number;

  /**
   * Specifies the rate at which the local node is receiving media data from peers, from the server, and over IP multicast, in bytes per second.
   * @see #receiveControlBytesPerSecond
   * @see #receiveDataBytesPerSecondFromIPMulticast
   * @see #receiveDataBytesPerSecondFromServer
   * @see #sendDataBytesPerSecond
   *
   */
  public native function get receiveDataBytesPerSecond():Number;

  /**
   * Specifies the rate at which the local node is receiving data from IP Multicast, in bytes per second.
   * @see #receiveControlBytesPerSecond
   * @see #receiveDataBytesPerSecond
   * @see #receiveDataBytesPerSecondFromServer
   * @see #sendDataBytesPerSecond
   *
   */
  public native function get receiveDataBytesPerSecondFromIPMulticast():Number;

  /**
   * Specifies the rate at which the local node is receiving media data from the server, in bytes per second.
   * @see #receiveControlBytesPerSecond
   * @see #receiveDataBytesPerSecond
   * @see #receiveDataBytesPerSecondFromIPMulticast
   * @see #sendDataBytesPerSecond
   *
   */
  public native function get receiveDataBytesPerSecondFromServer():Number;

  /**
   * Specifies the rate at which the local node is sending control overhead messages to peers and the server, in bytes per second.
   * @see #receiveControlBytesPerSecond
   * @see #sendControlBytesPerSecondToServer
   * @see #sendDataBytesPerSecond
   *
   */
  public native function get sendControlBytesPerSecond():Number;

  /**
   * Specifies the rate at which the local node is sending control overhead messages to the server, in bytes per second.
   * @see #receiveDataBytesPerSecondFromServer
   * @see #sendControlBytesPerSecond
   * @see #sendDataBytesPerSecond
   *
   */
  public native function get sendControlBytesPerSecondToServer():Number;

  /**
   * Specifies the rate at which media data is being sent by the local node to peers, in bytes per second.
   * @see #receiveDataBytesPerSecond
   * @see #sendControlBytesPerSecond
   * @see #sendControlBytesPerSecondToServer
   *
   */
  public native function get sendDataBytesPerSecond():Number;

  /**
   * Returns a string listing the properties of the NetStreamMulticastInfo object.
   * @return A string containing the values of the properties of the NetStreamMulticastInfo object
   *
   */
  public native function toString():String;
}
}