package flash.ui {


/**
 * The ContextMenuBuiltInItems class describes the items that are built in to a context menu. You can hide these items by using the <code>ContextMenu.hideBuiltInItems()</code> method.
 * <p><a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/ui/ContextMenuBuiltInItems.html#includeExamplesSummary">View the examples</a></p>
 * @see ContextMenu#hideBuiltInItems()
 *
 */
public final class ContextMenuBuiltInItems {
  /**
   * Lets the user move forward or backward one frame in a SWF file at run time (does not appear for a single-frame SWF file).
   */
  public native function get forwardAndBack():Boolean;

  /**
   * @private
   */
  public native function set forwardAndBack(value:Boolean):void;

  /**
   * Lets the user set a SWF file to start over automatically when it reaches the final frame (does not appear for a single-frame SWF file).
   */
  public native function get loop():Boolean;

  /**
   * @private
   */
  public native function set loop(value:Boolean):void;

  /**
   * Lets the user start a paused SWF file (does not appear for a single-frame SWF file).
   */
  public native function get play():Boolean;

  /**
   * @private
   */
  public native function set play(value:Boolean):void;

  /**
   * Lets the user send the displayed frame image to a printer.
   */
  public native function get print():Boolean;

  /**
   * @private
   */
  public native function set print(value:Boolean):void;

  /**
   * Lets the user set the resolution of the SWF file at run time.
   */
  public native function get quality():Boolean;

  /**
   * @private
   */
  public native function set quality(value:Boolean):void;

  /**
   * Lets the user set a SWF file to play from the first frame when selected, at any time (does not appear for a single-frame SWF file).
   */
  public native function get rewind():Boolean;

  /**
   * @private
   */
  public native function set rewind(value:Boolean):void;

  /**
   * Lets the user with Shockmachine installed save a SWF file.
   */
  public native function get save():Boolean;

  /**
   * @private
   */
  public native function set save(value:Boolean):void;

  /**
   * Lets the user zoom in and out on a SWF file at run time.
   */
  public native function get zoom():Boolean;

  /**
   * @private
   */
  public native function set zoom(value:Boolean):void;

  /**
   * Creates a new ContextMenuBuiltInItems object so that you can set the properties for Flash Player to display or hide each menu item.
   */
  public function ContextMenuBuiltInItems(){super();}
}
}