package flashx.textLayout.formats {


/**
 * Defines values for the <code>verticalAlign</code> property of the TextLayoutFormat class. Specifies how TextFlow elements align with their containers.
 * @see TextLayoutFormat#verticalAlign
 *
 */
public final class VerticalAlign {
  /**
   * Specifies alignment with the bottom edge of the frame.
   */
  public static const BOTTOM:String = "bottom";
  /**
   * Specifies vertical line justification within the frame
   */
  public static const JUSTIFY:String = "justify";
  /**
   * Specifies alignment with the middle of the frame.
   */
  public static const MIDDLE:String = "middle";
  /**
   * Specifies alignment with the top edge of the frame.
   */
  public static const TOP:String = "top";
}
}