package flashx.textLayout.operations {
import flashx.textLayout.edit.SelectionState;
import flashx.textLayout.edit.TextScrap;
import flashx.textLayout.operations.FlowTextOperation;

/**
 * The CutOperation class encapsulates a cut operation.
 * <p>The specified range is removed from the text flow.</p>
 * <p><b>Note:</b> The edit manager is responsible for copying the text scrap to the clipboard. Undoing a cut operation does not restore the original clipboard state.</p>
 * @see flashx.textLayout.edit.EditManager
 * @see flashx.textLayout.events.FlowOperationEvent
 *
 */
public class CutOperation extends FlowTextOperation {
  /**
   * scrapToCut the original removed text
   */
  public native function get scrapToCut():TextScrap;

  /**
   * @private
   */
  public native function set scrapToCut(value:TextScrap):void;

  /**
   * Creates a CutOperation object.
   * @param operationState The range of text to be cut.
   * @param scrapToCut A copy of the deleted text.
   *
   */
  public function CutOperation(operationState:SelectionState, scrapToCut:TextScrap){super(null);}
}
}