joo.classLoader.prepare("package flash.utils",/* {*/
"public class UIDUtil",1,function($$private){return[ 
  //--------------------------------------------------------------------------
  //
  //  Class constants
  //
  //--------------------------------------------------------------------------

  /**
   *  @private
   *  Char codes for 0123456789ABCDEF
   */
  "private static const",{ ALPHA_CHAR_CODES/*:Array*/ :function(){return( [48, 49, 50, 51, 52, 53, 54,
    55, 56, 57, 65, 66, 67, 68, 69, 70]);}},

  //--------------------------------------------------------------------------
  //
  //  Class methods
  //
  //--------------------------------------------------------------------------

  /**
   *  Generates a UID (unique identifier) based on ActionScript's
   *  pseudo-random number generator and the current time.
   *
   *  <p>The UID has the form
   *  <code>"XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX"</code>
   *  where X is a hexadecimal digit (0-9, A-F).</p>
   *
   *  <p>This UID will not be truly globally unique; but it is the best
   *  we can do without player support for UID generation.</p>
   *
   *  @return The newly-generated UID.
   *
   *  @langversion 3.0
   *  @playerversion Flash 9
   *  @playerversion AIR 1.1
   *  @productversion Flex 3
   */
  "public static function createUID",function createUID()/*:String*/ {
    var uid/*:Array*/ = new Array(36);
    var index/*:int*/ = 0;

    var i/*:int*/;
    var j/*:int*/;

    for (i = 0; i < 8; i++) {
      uid[index++] = $$private.ALPHA_CHAR_CODES[Math.floor(Math.random() * 16)];
    }

    for (i = 0; i < 3; i++) {
      uid[index++] = 45; // charCode for "-"

      for (j = 0; j < 4; j++) {
        uid[index++] = $$private.ALPHA_CHAR_CODES[Math.floor(Math.random() * 16)];
      }
    }

    uid[index++] = 45; // charCode for "-"

    var time/*:Number*/ = new Date().getTime();
    // Note: time is the number of milliseconds since 1970,
    // which is currently more than one trillion.
    // We use the low 8 hex digits of this number in the UID.
    // Just in case the system clock has been reset to
    // Jan 1-4, 1970 (in which case this number could have only
    // 1-7 hex digits), we pad on the left with 7 zeros
    // before taking the low digits.
    var timeString/*:String*/ = ("0000000" + time.toString(16).toUpperCase()).substr(-8);

    for (i = 0; i < 8; i++) {
      uid[index++] = timeString.charCodeAt(i);
    }

    for (i = 0; i < 4; i++) {
      uid[index++] = $$private.ALPHA_CHAR_CODES[Math.floor(Math.random() * 16)];
    }

    return String.fromCharCode.apply(null, uid);
  },

  "public function UIDUtil",function UIDUtil() {

  },
undefined];},["createUID"],["Array","Math","Date","String"], "0.8.0", "0.9.12"
);