package flash.printing {


/**
 * This class provides values that are used by the <code>PrintJob.orientation</code> property for the image position of a printed page.
 * @see PrintJob#orientation
 * @see http://help.adobe.com/en_US/as3/dev/WS5b3ccc516d4fbf351e63e3d118a9b90204-7cc6.html Setting size, scale, and orientation
 * @see http://help.adobe.com/en_US/as3/dev/WS5b3ccc516d4fbf351e63e3d118a9b90204-7cb4.html Printing for landscape or portrait orientation
 *
 */
public final class PrintJobOrientation {
  /**
   * The landscape (horizontal) image orientation for printing. This constant is used with the <code>PrintJob.orientation</code> property. Use the syntax <code>PrintJobOrientation.LANDSCAPE</code>.
   * @see PrintJob#orientation
   * @see #PORTRAIT
   *
   */
  public static const LANDSCAPE:String = "landscape";
  /**
   * The portrait (vertical) image orientation for printing. This constant is used with the <code>PrintJob.orientation</code> property. Use the syntax <code>PrintJobOrientation.PORTRAIT</code>.
   * @see PrintJob#orientation
   * @see #LANDSCAPE
   *
   */
  public static const PORTRAIT:String = "portrait";
}
}