package flash.system {


/**
 * The SecurityPanel class provides values for specifying which Security Settings panel you want to display.
 * <p>This class contains static constants that are used with the <code>Security.showSettings()</code> method. You cannot create new instances of the SecurityPanel class.</p>
 * <p><a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/system/SecurityPanel.html#includeExamplesSummary">View the examples</a></p>
 */
public final class SecurityPanel {
  /**
   * When passed to <code>Security.showSettings()</code>, displays the Camera panel in Flash Player Settings.
   * @see Security#showSettings()
   *
   */
  public static const CAMERA:String = "camera";
  /**
   * When passed to <code>Security.showSettings()</code>, displays the panel that was open the last time the user closed the Flash Player Settings.
   * @see Security#showSettings()
   *
   */
  public static const DEFAULT:String = "default";
  /**
   * When passed to <code>Security.showSettings()</code>, displays the Display panel in Flash Player Settings.
   * @see Security#showSettings()
   *
   */
  public static const DISPLAY:String = "display";
  /**
   * When passed to <code>Security.showSettings()</code>, displays the Local Storage Settings panel in Flash Player Settings.
   * @see Security#showSettings()
   *
   */
  public static const LOCAL_STORAGE:String = "localStorage";
  /**
   * When passed to <code>Security.showSettings()</code>, displays the Microphone panel in Flash Player Settings.
   * @see Security#showSettings()
   *
   */
  public static const MICROPHONE:String = "microphone";
  /**
   * When passed to <code>Security.showSettings()</code>, displays the Privacy Settings panel in Flash Player Settings.
   * @see Security#showSettings()
   *
   */
  public static const PRIVACY:String = "privacy";
  /**
   * When passed to <code>Security.showSettings()</code>, displays the Settings Manager (in a separate browser window).
   * @see Security#showSettings()
   *
   */
  public static const SETTINGS_MANAGER:String = "settingsManager";
}
}