package flash.utils {


/**
 * The Proxy class lets you override the default behavior of ActionScript operations (such as retrieving and modifying properties) on an object.
 * <p>The Proxy class has no constructor, and you should not attempt to instantiate Proxy. Instead, subclass the Proxy class to override methods such as <code>getProperty</code> and provide custom behavior. If you try to use a method of the Proxy class without overriding the method, an exception is thrown.</p>
 * <p>And, keep in mind, your own code overriding the methods of the Proxy class can throw exceptions unintentionally. Throwing exceptions when using these methods causes problems because the calling code (using operators like <code>in</code>, <code>is</code>, <code>delete</code> and others) does not expect exceptions. Unless you're already sure your overriding method does not throw exceptions, Adobe recommends using <code>try..catch</code> statements around your implementation of the Proxy class to avoid fatal errors when operators call your methods. For example:</p>
 * <listing>
 *  dynamic class MyProxy extends Proxy {
 *      flash_proxy override function callProperty(name:*, ...rest):* {
 *        try {
 *          // custom code here
 *        }
 *        catch (e:Error) {
 *          // respond to error here
 *        }
 *  }
 * </listing>
 * <p>The Proxy class is a replacement for the <code>Object.__resolve</code> and <code>Object.addProperty</code> features of ActionScript 2.0, which are no longer available in ActionScript 3.0. The <code>Object.addProperty()</code> feature allowed you to dynamically create get and set methods in ActionScript 2.0. Although ActionScript 3.0 provides get and set methods at compile time, you cannot dynamically assign one to an object unless you use the Proxy class.</p>
 * <p>To avoid collisions with the <code>public</code> namespace, the methods of the Proxy class are in the <code>flash_proxy</code> namespace.</p>
 * <p>Where methods of the Proxy class take a <code>name</code> argument, <code>name</code> can be either a String or a QName object (if namespaces are being used).</p>
 * <p><a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/utils/Proxy.html#includeExamplesSummary">View the examples</a></p>
 */
public class Proxy {
}
}