package flash.utils {
public class UIDUtil {

  //--------------------------------------------------------------------------
  //
  //  Class methods
  //
  //--------------------------------------------------------------------------

  /**
   *  Generates a UID (unique identifier) based on ActionScript's
   *  pseudo-random number generator and the current time.
   *
   *  <p>The UID has the form
   *  <code>"XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX"</code>
   *  where X is a hexadecimal digit (0-9, A-F).</p>
   *
   *  <p>This UID will not be truly globally unique; but it is the best
   *  we can do without player support for UID generation.</p>
   *
   *  @return The newly-generated UID.
   *
   *  @langversion 3.0
   *  @playerversion Flash 9
   *  @playerversion AIR 1.1
   *  @productversion Flex 3
   */
  public static native function createUID():String;

  public function UIDUtil(){super();}
}
}