package flashx.textLayout.edit {
import flashx.textLayout.elements.FlowLeafElement;
import flashx.textLayout.elements.ParagraphElement;
import flashx.textLayout.elements.TextFlow;
import flashx.textLayout.formats.ITextLayoutFormat;

/**
 * The ElementRange class represents the range of objects selected within a text flow.
 * <p>The beginning elements (such as <code>firstLeaf</code>) are always less than or equal to the end elements (in this case, <code>lastLeaf</code>) for each pair of values in an element range.</p>
 * @see flashx.textLayout.elements.TextFlow
 *
 */
public class ElementRange {
  /**
   * The absolute text position of the FlowLeafElement object that contains the end of the range.
   */
  public native function get absoluteEnd():int;

  /**
   * @private
   */
  public native function set absoluteEnd(value:int):void;

  /**
   * The absolute text position of the FlowLeafElement object that contains the start of the range.
   */
  public native function get absoluteStart():int;

  /**
   * @private
   */
  public native function set absoluteStart(value:int):void;

  /**
   * The format attributes of the characters in the range.
   * <p>If the range spans more than one FlowElement object, which means that more than one character format may exist within the range, the format of the first FlowElement object is returned.</p>
   */
  public native function get characterFormat():ITextLayoutFormat;

  /**
   * The format attributes of the container displaying the range.
   * <p>If the range spans more than one container, the format of the first container is returned.</p>
   */
  public native function get containerFormat():ITextLayoutFormat;

  /**
   * The FlowLeafElement object that contains the start of the range.
   */
  public native function get firstLeaf():FlowLeafElement;

  /**
   * @private
   */
  public native function set firstLeaf(value:FlowLeafElement):void;

  /**
   * The ParagraphElement object that contains the start of the range.
   */
  public native function get firstParagraph():ParagraphElement;

  /**
   * @private
   */
  public native function set firstParagraph(value:ParagraphElement):void;

  /**
   * The FlowLeafElement object that contains the end of the range.
   */
  public native function get lastLeaf():FlowLeafElement;

  /**
   * @private
   */
  public native function set lastLeaf(value:FlowLeafElement):void;

  /**
   * The ParagraphElement object that contains the end of the range.
   */
  public native function get lastParagraph():ParagraphElement;

  /**
   * @private
   */
  public native function set lastParagraph(value:ParagraphElement):void;

  /**
   * The format attributes of the paragraph containing the range.
   * <p>If the range spans more than one paragraph, the format of the first paragraph is returned.</p>
   */
  public native function get paragraphFormat():ITextLayoutFormat;

  /**
   * The TextFlow object that contains the range.
   */
  public native function get textFlow():TextFlow;

  /**
   * @private
   */
  public native function set textFlow(value:TextFlow):void;

  /**
   * Creates an ElementRange object.
   * @param textFlow the text flow
   * @param absoluteStart absolute text position of the first character in the text range
   * @param absoluteEnd one beyond the absolute text position of the last character in the text range
   *
   * @return <code><a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flashx/textLayout/edit/ElementRange.html">ElementRange</a></code>
   *
   */
  public static native function createElementRange(textFlow:TextFlow, absoluteStart:int, absoluteEnd:int):ElementRange;
}
}