package flashx.textLayout.events {
import flash.events.Event;
import flashx.textLayout.elements.TextFlow;

/**
 * A TextFlow instance dispatches this each time it is marked as damaged. Damage can be caused by changes to the model or changes to the layout.
 * <p><a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flashx/textLayout/events/DamageEvent.html#includeExamplesSummary">View the examples</a></p>
 * @see flashx.textLayout.elements.TextFlow
 *
 */
public class DamageEvent extends Event {
  /**
   * Absolute start of the damage
   */
  public native function get damageAbsoluteStart():int;

  /**
   * Length of the damage
   */
  public native function get damageLength():int;

  /**
   * TextFlow owning the damage
   */
  public native function get textFlow():TextFlow;

  /**
   * Constructor
   * @param type text index of the start of the damage
   * @param bubbles length of text that was damaged
   * @param cancelable <code>cancelable:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/Boolean.html">Boolean</a></code> (default = <code>false</code>)
   * @param textFlow <code>textFlow:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flashx/textLayout/elements/TextFlow.html">flashx.textLayout.elements:TextFlow</a></code> (default = <code>null</code>)
   * @param damageAbsoluteStart <code>damageAbsoluteStart:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/int.html">int</a></code> (default = <code>0</code>)
   * @param damageLength <code>damageLength:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/int.html">int</a></code> (default = <code>0</code>)
   *
   */
  public function DamageEvent(type:String, bubbles:Boolean = false, cancelable:Boolean = false, textFlow:TextFlow = null, damageAbsoluteStart:int = 0, damageLength:int = 0){super(null);}

  /**
   * Event type for DamageEvent
   */
  public static const DAMAGE:String = "damage";
}
}