package flashx.textLayout.operations {
import flashx.textLayout.edit.SelectionState;
import flashx.textLayout.formats.ITextLayoutFormat;
import flashx.textLayout.operations.FlowTextOperation;

/**
 * The InsertTextOperation class encapsulates a text insertion operation.
 * @see flashx.textLayout.edit.EditManager
 * @see flashx.textLayout.events.FlowOperationEvent
 *
 */
public class InsertTextOperation extends FlowTextOperation {
  /**
   * The character format applied to the inserted text.
   */
  public native function get characterFormat():ITextLayoutFormat;

  /**
   * @private
   */
  public native function set characterFormat(value:ITextLayoutFormat):void;

  /**
   * The text deleted by this operation, if any.
   * <p><code>null</code> if no text is deleted.</p>
   */
  public native function get deleteSelectionState():SelectionState;

  /**
   * @private
   */
  public native function set deleteSelectionState(value:SelectionState):void;

  /**
   * The text inserted by this operation.
   */
  public native function get text():String;

  /**
   * @private
   */
  public native function set text(value:String):void;

  /**
   * Creates an InsertTextOperation object.
   * @param operationState Describes the insertion point or range of text.
   * @param text The string to insert.
   * @param deleteSelectionState Describes the range of text to delete before doing insertion, if different than the range described by <code>operationState</code>.
   *
   */
  public function InsertTextOperation(operationState:SelectionState, text:String, deleteSelectionState:SelectionState = null){super(null);}

  /**
   * Re-executes the operation after it has been undone.
   * <p>This function is called by the edit manager, when necessary.</p>
   * @return <code><a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flashx/textLayout/edit/SelectionState.html">SelectionState</a></code>
   *
   */
  override public native function redo():SelectionState;
}
}