package flashx.textLayout.operations {
import flashx.textLayout.operations.FlowOperation;


/**
 * The UndoOperation class encapsulates an undo operation.
 * <p><a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flashx/textLayout/operations/UndoOperation.html#includeExamplesSummary">View the examples</a></p>
 * @see flashx.textLayout.edit.EditManager
 * @see flashx.textLayout.events.FlowOperationEvent
 *
 */
public class UndoOperation extends FlowOperation {
  /**
   * The operation to undo.
   */
  public native function get operation():FlowOperation;

  /**
   * @private
   */
  public native function set operation(value:FlowOperation):void;

  /**
   * Creates an UndoOperation object.
   * @param op The operation to undo.
   *
   */
  public function UndoOperation(op:FlowOperation){super(null);}
}
}