/*
 * Copyright 2009 CoreMedia AG
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 
 *
 * Unless required by applicable law or agreed to in writing, 
 * software distributed under the License is distributed on an "AS
 * IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either 
 * express or implied. See the License for the specific language 
 * governing permissions and limitations under the License.
 */

// JangarooScript runtime support. Author: Frank Wienberg

package joo {
import joo.JooClassDeclaration;
import joo.NativeClassDeclaration;

public class SystemClassLoader {

  public static const classDeclarationsByName : Object;

  public var debug : Boolean;

  public function SystemClassLoader(){super();}

  public native function prepare(...params) : JooClassDeclaration;

  protected native function createClassDeclaration(packageDef:String, metadata:Object, classDef:String, inheritanceLevel:int, memberFactory:Function, publicStaticMethodNames:Array, dependencies:Array) : JooClassDeclaration;

  public native function getClassDeclaration(fullClassName : String) : NativeClassDeclaration;

  /**
   * @param className
   * @return NativeClassDeclaration the class declaration with the given name.
   * @throws Error - ClassNotFound
   */
  public native function getRequiredClassDeclaration(className : String) : NativeClassDeclaration;

  protected native function createNativeClassDeclaration(fullClassName : String, nativeClass : Function) : NativeClassDeclaration;

  public native function init(... classes) :Function;
}
}