/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.exml.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.jangaroo.exml.model.DescriptionHolder;

public final class ConfigAttribute
extends DescriptionHolder {
    private static final Set<String> SIMPLE_TYPES = new HashSet<String>(Arrays.asList("Boolean", "Number", "Date", "String"));
    private static final Collection<String> SEQUENCE_TYPES = new HashSet<String>(Arrays.asList("Array", "MixedCollection", "Mixed"));
    private String name;
    private String type;

    public ConfigAttribute(String name, String type, String description) {
        super(description);
        if (type == null) {
            throw new IllegalArgumentException("The type should not be null for config attribute: '" + name + "'");
        }
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getXsType() {
        return this.isSimple() ? this.type : "String";
    }

    public boolean isSimple() {
        return SIMPLE_TYPES.contains(this.type);
    }

    public boolean isSequence() {
        return SEQUENCE_TYPES.contains(this.type);
    }

    public boolean isObject() {
        return !SIMPLE_TYPES.contains(this.type) && !SEQUENCE_TYPES.contains(this.type);
    }

    public String toString() {
        return this.name + " : " + this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigAttribute that = (ConfigAttribute)o;
        return this.name.equals(that.name) && this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }
}

