package flash.display {


/**
 * The CapsStyle class is an enumeration of constant values that specify the caps style to use in drawing lines. The constants are provided for use as values in the <code>caps</code> parameter of the <code>flash.display.Graphics.lineStyle()</code> method. You can specify the following three types of caps:
 * <p><img src="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/images/linecap.jpg" /></p>
 * <p><a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/display/CapsStyle.html#includeExamplesSummary">View the examples</a></p>
 * @see Graphics#lineStyle()
 *
 */
public final class CapsStyle {
  /**
   * Used to specify no caps in the <code>caps</code> parameter of the <code>flash.display.Graphics.lineStyle()</code> method.
   */
  public static const NONE:String = "none";
  /**
   * Used to specify round caps in the <code>caps</code> parameter of the <code>flash.display.Graphics.lineStyle()</code> method.
   */
  public static const ROUND:String = "round";
  /**
   * Used to specify square caps in the <code>caps</code> parameter of the <code>flash.display.Graphics.lineStyle()</code> method.
   */
  public static const SQUARE:String = "square";
}
}