package flash.display {


/**
 * The StageAlign class provides constant values to use for the <code>Stage.align</code> property.
 * @see Stage#align
 *
 */
public final class StageAlign {
  /**
   * Specifies that the Stage is aligned at the bottom.
   */
  public static const BOTTOM:String = "B";
  /**
   * Specifies that the Stage is aligned in the bottom-left corner.
   */
  public static const BOTTOM_LEFT:String = "BL";
  /**
   * Specifies that the Stage is aligned in the bottom-right corner.
   */
  public static const BOTTOM_RIGHT:String = "BR";
  /**
   * Specifies that the Stage is aligned on the left.
   */
  public static const LEFT:String = "L";
  /**
   * Specifies that the Stage is aligned to the right.
   */
  public static const RIGHT:String = "R";
  /**
   * Specifies that the Stage is aligned at the top.
   */
  public static const TOP:String = "T";
  /**
   * Specifies that the Stage is aligned in the top-left corner.
   */
  public static const TOP_LEFT:String = "TL";
  /**
   * Specifies that the Stage is aligned in the top-right corner.
   */
  public static const TOP_RIGHT:String = "TR";
}
}