package flash.events {


/**
 * The DRMManager dispatches a DRMAuthenticationErrorEvent object when a call to the <code>authenticate()</code> method of the DRMManager object fails.
 */
public class DRMAuthenticationErrorEvent extends flash.events.ErrorEvent {
  /**
   * The content domain of the media rights server. Here, domain is not a network or Internet domain name.
   */
  public native function get domain():String;

  /**
   * @private
   */
  public native function set domain(value:String):void;

  /**
   * The URL of the media rights server that rejected the authentication attempt.
   */
  public native function get serverURL():String;

  /**
   * @private
   */
  public native function set serverURL(value:String):void;

  /**
   * A more detailed error code.
   */
  public native function get subErrorID():int;

  /**
   * @private
   */
  public native function set subErrorID(value:int):void;

  /**
   * Creates a new instance of a DRMAuthenticationErrorEvent object.
   * @param type the event type string
   * @param bubbles whether the event bubbles up the display list
   * @param cancelable whether the event can be canceled
   * @param inDetail The error description
   * @param inErrorID The ID of the general type of error
   * @param inSubErrorID The ID indicating the specific error within its type
   * @param inServerURL the URL of the logged-in server
   * @param inDomain the authenticated domain on the logged-in server
   *
   */
  public function DRMAuthenticationErrorEvent(type:String, bubbles:Boolean = false, cancelable:Boolean = false, inDetail:String = "", inErrorID:int = 0, inSubErrorID:int = 0, inServerURL:String = null, inDomain:String = null){super(null);}

  /**
   * Creates a copy of the ErrorEvent object and sets the value of each property to match that of the original.
   * @return A new ErrorEvent object with property values that match those of the original.
   *
   */
  override public native function clone():Event;

  /**
   * The string constant to use for the authentication error event in the type parameter when adding and removing event listeners.
   */
  public static const AUTHENTICATION_ERROR:String = "authenticationError";
}
}