package flash.text.engine {


/**
 * The TypographicCase class is an enumeration of constant values for setting the <code>typographicCase</code> property of the ElementFormat class.
 * @see ElementFormat#typographicCase
 *
 */
public final class TypographicCase {
  /**
   * Specifies that spacing is adjusted for uppercase characters on output.
   */
  public static const CAPS:String = "caps";
  /**
   * Specifies that all lowercase characters use small-caps glyphs on output.
   */
  public static const CAPS_AND_SMALL_CAPS:String = "capsAndSmallCaps";
  /**
   * Specifies default typographic case. The results are font-dependent; characters use the settings specified by the font designer without any features applied.
   */
  public static const DEFAULT:String = "default";
  /**
   * Specifies that all characters use lowercase glyphs on output.
   */
  public static const LOWERCASE:String = "lowercase";
  /**
   * Specifies that uppercase characters use small-caps glyphs on output.
   */
  public static const SMALL_CAPS:String = "smallCaps";
  /**
   * Specifies that uppercase characters use title glyphs on output.
   */
  public static const TITLE:String = "title";
  /**
   * Specifies that all characters use uppercase glyphs on output.
   */
  public static const UPPERCASE:String = "uppercase";
}
}