package flashx.textLayout.edit {
import flash.events.ContextMenuEvent;
import flash.events.Event;
import flash.events.FocusEvent;
import flash.events.IMEEvent;
import flash.events.KeyboardEvent;
import flash.events.MouseEvent;
import flash.events.TextEvent;

import flashx.textLayout.elements.TextFlow;
import flashx.textLayout.elements.TextRange;
import flashx.textLayout.formats.ITextLayoutFormat;
import flashx.textLayout.operations.FlowOperation;

/**
 * The SelectionManager class manages text selection in a text flow.
 * <p>The selection manager keeps track of the selected text range, manages its formatting, and can handle events affecting the selection. To allow a user to make selections in a text flow, assign a SelectionManager object to the <code>interactionManager</code> property of the flow. (To allow editing, assign an instance of the EditManager class, which extends SelectionManager.)</p>
 * <p>The following table describes how the SelectionManager class handles keyboard shortcuts:</p>
 * <table>
 * <tr><th>TB,LTR</th><th>TB,RTL</th><th>TL,LTR</th><th>RL,RTL</th></tr>
 * <tr><th>none</th><th>ctrl</th><th>alt|ctrl+alt</th><th>none</th><th>ctrl</th><th>alt|ctrl+alt</th><th>none</th><th>ctrl</th><th>alt|ctrl+alt</th><th>none</th><th>ctrl</th><th>alt|ctrl+alt</th></tr>
 * <tr>
 * <td>leftarrow</td>
 * <td>previousCharacter</td>
 * <td>previousWord</td>
 * <td>previousWord</td>
 * <td>nextCharacter</td>
 * <td>nextWord</td>
 * <td>nextWord</td>
 * <td>nextLine</td>
 * <td>endOfDocument</td>
 * <td>endOfParagraph</td>
 * <td>nextLine</td>
 * <td>endOfDocument</td>
 * <td>endOfParagraph</td></tr>
 * <tr>
 * <td>uparrow</td>
 * <td>previousLine</td>
 * <td>startOfDocument</td>
 * <td>startOfParagraph</td>
 * <td>previousLine</td>
 * <td>startOfDocument</td>
 * <td>startOfParagraph</td>
 * <td>previousCharacter</td>
 * <td>previousWord</td>
 * <td>previousWord</td>
 * <td>nextCharacter</td>
 * <td>nextWord</td>
 * <td>nextWord</td></tr>
 * <tr>
 * <td>rightarrow</td>
 * <td>nextCharacter</td>
 * <td>nextWord</td>
 * <td>nextWord</td>
 * <td>previousCharacter</td>
 * <td>previousWord</td>
 * <td>previousWord</td>
 * <td>previousLine</td>
 * <td>startOfDocument</td>
 * <td>startOfParagraph</td>
 * <td>previousLine</td>
 * <td>startOfDocument</td>
 * <td>startOfParagraph</td></tr>
 * <tr>
 * <td>downarrow</td>
 * <td>nextLine</td>
 * <td>endOfDocument</td>
 * <td>endOfParagraph</td>
 * <td>nextLine</td>
 * <td>endOfDocument</td>
 * <td>endOfParagraph</td>
 * <td>nextCharacter</td>
 * <td>nextWord</td>
 * <td>nextWord</td>
 * <td>previousCharacter</td>
 * <td>previousWord</td>
 * <td>previousWord</td></tr>
 * <tr>
 * <td>home</td>
 * <td>startOfLine</td>
 * <td>startOfDocument</td>
 * <td>startOfLine</td>
 * <td>startOfLine</td>
 * <td>startOfDocument</td>
 * <td>startOfLine</td>
 * <td>startOfLine</td>
 * <td>startOfDocument</td>
 * <td>startOfLine</td>
 * <td>startOfLine</td>
 * <td>startOfDocument</td>
 * <td>startOfLine</td></tr>
 * <tr>
 * <td>end</td>
 * <td>endOfLine</td>
 * <td>endOfDocument</td>
 * <td>endOfLine</td>
 * <td>endOfLine</td>
 * <td>endOfDocument</td>
 * <td>endOfLine</td>
 * <td>endOfLine</td>
 * <td>endOfDocument</td>
 * <td>endOfLine</td>
 * <td>endOfLine</td>
 * <td>endOfDocument</td>
 * <td>endOfLine</td></tr>
 * <tr>
 * <td>pagedown</td>
 * <td>nextPage</td>
 * <td>nextPage</td>
 * <td>nextPage</td>
 * <td>nextPage</td>
 * <td>nextPage</td>
 * <td>nextPage</td>
 * <td>nextPage</td>
 * <td>nextPage</td>
 * <td>nextPage</td>
 * <td>nextPage</td>
 * <td>nextPage</td>
 * <td>nextPage</td></tr>
 * <tr>
 * <td>pageup</td>
 * <td>previousPage</td>
 * <td>previousPage</td>
 * <td>previousPage</td>
 * <td>previousPage</td>
 * <td>previousPage</td>
 * <td>previousPage</td>
 * <td>previousPage</td>
 * <td>previousPage</td>
 * <td>previousPage</td>
 * <td>previousPage</td>
 * <td>previousPage</td>
 * <td>previousPage</td></tr></table>
 * <p><b>Key:</b></p>
 * <ul>
 * <li>none = no modifier</li>
 * <li>ctrl, shift, alt = modifiers</li>
 * <li>alt-key and ctrl+alt-key are the same on all platforms (on some platforms alt-key does not get to TLF)</li>
 * <li>shift key modifes to extend the active end of the selection in the specified manner</li>
 * <li>TB (top-to-bottom),RL (right-to-left) are textFlow level <code>blockProgression</code> settings</li>
 * <li>LTR (left-to-right),RTL (right-to-left) are textFlow level <code>direction</code> settings</li>
 * <li>next and prev in logical order in the textFlow - the effect in RTL text is that the selection moves in the physical direction</li></ul>
 * <p><a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flashx/textLayout/edit/SelectionManager.html#includeExamplesSummary">View the examples</a></p>
 * @see EditManager
 *
 */
public class SelectionManager implements flashx.textLayout.edit.ISelectionManager {
  /**
   * The text position of the end of the selection, as an offset from the start of the text flow.
   * <p>The absolute end is the same as either the active or the anchor point of the selection, whichever comes last in the text flow.</p>
   */
  public native function get absoluteEnd():int;

  /**
   * The text position of the start of the selection, as an offset from the start of the text flow.
   * <p>The absolute start is the same as either the active or the anchor point of the selection, whichever comes first in the text flow.</p>
   */
  public native function get absoluteStart():int;

  /**
   * The active point of the selection.
   * <p>The <i>active</i> point is the volatile end of the selection. The active point is changed when the selection is modified. The active point can be at either the beginning or the end of the selection.</p>
   */
  public native function get activePosition():int;

  /**
   * The anchor point of the selection.
   * <p>An <i>anchor</i> point is the stable end of the selection. When the selection is extended, the anchor point does not change. The anchor point can be at either the beginning or the end of the selection.</p>
   */
  public native function get anchorPosition():int;

  /**
   * The current SelectionFormat object.
   * <p>The current SelectionFormat object is chosen from the SelectionFormat objects assigned to the <code>unfocusedSelectionFormat</code>, <code>inactiveSelectionFormat</code> and <code>focusedSelectionFormat</code> properties based on the current state of the <code>windowActive</code> and <code>focused</code> properties.</p>
   * @see SelectionFormat
   *
   */
  public native function get currentSelectionFormat():SelectionFormat;

  /**
   * The editing mode.
   * <p>The editing mode indicates whether the text flow supports selection, editing, or only reading. A text flow is made selectable by assigning a selection manager and editable by assigning an edit manager. Constants representing the editing modes are defined in the EditingMode class.</p>
   * @see EditingMode
   *
   */
  public native function get editingMode():String;

  /**
   * Indicates whether a container in the text flow has the focus.
   * <p>The <code>focused</code> property is <code>true</code> if any of the containers in the text flow has key focus.</p>
   */
  public native function get focused():Boolean;

  /**
   * The SelectionFormat object used to draw the selection in a focused container.
   * @see SelectionFormat
   *
   */
  public native function get focusedSelectionFormat():SelectionFormat;

  /**
   * @private
   */
  public native function set focusedSelectionFormat(value:SelectionFormat):void;

  /**
   * The SelectionFormat object used to draw the selection when it is not in the active window.
   * @see SelectionFormat
   *
   */
  public native function get inactiveSelectionFormat():SelectionFormat;

  /**
   * @private
   */
  public native function set inactiveSelectionFormat(value:SelectionFormat):void;

  /**
   * The format that will be applied to inserted text. TBD: pointFormat needs to be extended to remember user styles and "undefine" of formats from calls to IEditManager.undefineFormat with leafFormat values on a point selection.
   */
  protected native function get pointFormat():ITextLayoutFormat;

  /**
   * The TextFlow object managed by this selection manager.
   * <p>A selection manager manages a single text flow. A selection manager can also be assigned to a text flow by setting the <code>interactionManager</code> property of the TextFlow object.</p>
   * @see flashx.textLayout.elements.TextFlow#interactionManager
   *
   */
  public native function get textFlow():TextFlow;

  /**
   * @private
   */
  public native function set textFlow(value:TextFlow):void;

  /**
   * The SelectionFormat object used to draw the selection when it is not in a focused container, but is in the active window.
   * @see SelectionFormat
   *
   */
  public native function get unfocusedSelectionFormat():SelectionFormat;

  /**
   * @private
   */
  public native function set unfocusedSelectionFormat(value:SelectionFormat):void;

  /**
   * Indicates whether the window associated with the text flow is active.
   * <p>The <code>windowActive</code> property is <code>true</code> if the window displaying with the text flow is the active window.</p>
   */
  public native function get windowActive():Boolean;

  /**
   * Creates a SelectionManager object.
   * <p>Assign a SelectionManager object to the <code>interactionManager</code> property of a text flow to enable text selection.</p>
   */
  public function SelectionManager(){super();}

  /**
   * Processes an activate event.
   * @param event <code>event:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/Event.html">Event</a></code>
   *
   */
  public native function activateHandler(event:Event):void;

  /**
   * Processes a deactivate event.
   * @param event <code>event:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/Event.html">Event</a></code>
   *
   */
  public native function deactivateHandler(event:Event):void;

  /**
   * Perform a SelectionManager operation - these may never modify the flow but clients still are able to cancel them.
   * @param op <code>op:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flashx/textLayout/operations/FlowOperation.html">FlowOperation</a></code>
   *
   */
  public native function doOperation(op:FlowOperation):void;

  /**
   * Processes an edit event.
   * <p>Edit events are dispatched for cut, copy, paste, and selectAll commands.</p>
   * @param event <code>event:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/Event.html">Event</a></code>
   *
   */
  public native function editHandler(event:Event):void;

  /**
   *
   */
  public native function flushPendingOperations():void;

  /**
   * Processes a focusChange event.
   * @param event <code>event:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/FocusEvent.html">FocusEvent</a></code>
   *
   */
  public native function focusChangeHandler(event:FocusEvent):void;

  /**
   * Processes a focusIn event.
   * @param event <code>event:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/FocusEvent.html">FocusEvent</a></code>
   *
   */
  public native function focusInHandler(event:FocusEvent):void;

  /**
   * Processes a focusOut event.
   * @param event <code>event:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/FocusEvent.html">FocusEvent</a></code>
   *
   */
  public native function focusOutHandler(event:FocusEvent):void;

  /**
   * Gets the character format attributes that are common to all characters in the specified text range or current selection.
   * <p>Format attributes that do not have the same value for all characters in the specified element range or selection are set to <code>null</code> in the returned ITextLayoutFormat instance.</p>
   * @param range The optional range of text for which common attributes are requested. If null, the current selection is used.
   *
   * @return The common character style settings
   *
   * @example The following example illustrates how to get an ITextLayoutFormat object containing the character style settings common to all elements in the selection. (The textFlow variable in the example is a TextFlow object.)
   * <listing>
   *  var common:ITextLayoutFormat = textFlow.interactionManager.getCommonCharacterFormat();
   * </listing>
   */
  public native function getCommonCharacterFormat(range:TextRange = null):ITextLayoutFormat;

  /**
   * Gets the container format attributes that are common to all containers in the specified text range or current selection.
   * <p>Format attributes that do not have the same value for all containers in the specified element range or selection are set to <code>null</code> in the returned ITextLayoutFormat instance.</p>
   * @param range The optional range of text for which common attributes are requested. If null, the current selection is used.
   *
   * @return The common container style settings
   *
   * @example The following example illustrates how to get an ITextLayoutFormat object containing the container style settings common to all elements in the selection. (The textFlow variable in the example is a TextFlow object.)
   * <listing>
   *  var common:ITextLayoutFormat = textFlow.interactionManager.getCommonContainerFormat();
   * </listing>
   */
  public native function getCommonContainerFormat(range:TextRange = null):ITextLayoutFormat;

  /**
   * Gets the paragraph format attributes that are common to all paragraphs in the specified text range or current selection.
   * <p>Format attributes that do not have the same value for all paragraphs in the specified element range or selection are set to <code>null</code> in the returned ITextLayoutFormat instance.</p>
   * @param range The optional range of text for which common attributes are requested. If null, the current selection is used.
   *
   * @return The common paragraph style settings
   *
   * @example The following example illustrates how to get an ITextLayoutFormat object containing the paragraph style settings common to all elements in the selection. (The textFlow variable in the example is a TextFlow object.)
   * <listing>
   *  var common:ITextLayoutFormat = textFlow.interactionManager.getCommonParagraphFormat();
   * </listing>
   */
  public native function getCommonParagraphFormat(range:TextRange = null):ITextLayoutFormat;

  /**
   * Gets the SelectionState object of the current selection.
   * @return <code><a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flashx/textLayout/edit/SelectionState.html">SelectionState</a></code>
   *
   * @see SelectionState
   *
   * @example The following example gets a SelectionState object for the current selection in a text flow. (The textFlow variable in the example is a TextFlow object.)
   * <listing>
   *  var selection:SelectionState = textFlow.interactionManager.getSelectionState();
   * </listing>
   */
  public native function getSelectionState():SelectionState;

  /**
   * Indicates whether there is a selection.
   * <p>Returns <code>true</code> if there is either a range selection or a point selection. By default, when a selection manager is first set up, there is no selection (the start and end are -1).</p>
   * @return <code><a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/Boolean.html">Boolean</a></code>
   *
   * @example The following example illustrates how to determine whether there a text flow has a selection. (The textFlow variable in the example is a TextFlow object.)
   * <listing>
   *  var selection:SelectionState = textFlow.interactionManager.hasSelection();
   * </listing>
   */
  public native function hasSelection():Boolean;

  /**
   * Processes an imeStartComposition event
   * @param event <code>event:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/IMEEvent.html">IMEEvent</a></code>
   *
   */
  public native function imeStartCompositionHandler(event:IMEEvent):void;

  /**
   * Indicates whether the selection covers a range of text.
   * <p>Returns <code>true</code> if there is a selection that extends past a single position.</p>
   * @return <code><a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/Boolean.html">Boolean</a></code>
   *
   * @example The following example illustrates how to determine whether the current selection in a text flow extends over a range of text. (The textFlow variable in the example is a TextFlow object.)
   * <listing>
   *  var selection:SelectionState = textFlow.interactionManager.isRangeSelection();
   * </listing>
   */
  public native function isRangeSelection():Boolean;

  /**
   * Processes a keyDown event.
   * @param event <code>event:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/KeyboardEvent.html">KeyboardEvent</a></code>
   *
   */
  public native function keyDownHandler(event:KeyboardEvent):void;

  /**
   * Processes a keyFocusChange event.
   * @param event <code>event:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/FocusEvent.html">FocusEvent</a></code>
   *
   */
  public native function keyFocusChangeHandler(event:FocusEvent):void;

  /**
   * Processes a keyUp event.
   * @param event <code>event:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/KeyboardEvent.html">KeyboardEvent</a></code>
   *
   */
  public native function keyUpHandler(event:KeyboardEvent):void;

  /**
   * Processes a menuSelect event.
   * @param event <code>event:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/ContextMenuEvent.html">ContextMenuEvent</a></code>
   *
   */
  public native function menuSelectHandler(event:ContextMenuEvent):void;

  /**
   * Processes a mouseDoubleClick event.
   * @param event <code>event:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/MouseEvent.html">MouseEvent</a></code>
   *
   */
  public native function mouseDoubleClickHandler(event:MouseEvent):void;

  /**
   * Processes a mouseDown event.
   * @param event <code>event:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/MouseEvent.html">MouseEvent</a></code>
   *
   */
  public native function mouseDownHandler(event:MouseEvent):void;

  /**
   * Processes a mouseMove event.
   * @param event <code>event:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/MouseEvent.html">MouseEvent</a></code>
   *
   */
  public native function mouseMoveHandler(event:MouseEvent):void;

  /**
   * Processes a mouseOut event.
   * @param event <code>event:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/MouseEvent.html">MouseEvent</a></code>
   *
   */
  public native function mouseOutHandler(event:MouseEvent):void;

  /**
   * Processes a mouseOver event.
   * @param event <code>event:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/MouseEvent.html">MouseEvent</a></code>
   *
   */
  public native function mouseOverHandler(event:MouseEvent):void;

  /**
   * Processes a mouseUp event.
   * @param event <code>event:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/MouseEvent.html">MouseEvent</a></code>
   *
   */
  public native function mouseUpHandler(event:MouseEvent):void;

  /**
   * Processes a mouseWheel event.
   * @param event <code>event:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/MouseEvent.html">MouseEvent</a></code>
   *
   */
  public native function mouseWheelHandler(event:MouseEvent):void;

  /**
   * Updates the selection manager when text is inserted or deleted.
   * <p>Operations must call <code>notifyInsertOrDelete</code> when changing the text in the text flow. The selection manager adjusts index-based position indicators accordingly. If you create a new Operation class that changes text in a text flow directly (not using another operation) your operation must call this function to keep the selection up to date.</p>
   * @param absolutePosition The point in the text where the change was made.
   * @param length A positive or negative number indicating how many characters were inserted or deleted.
   *
   * @example The following example illustrates how a function in a custom Operation class would call the <code>notifyInsertOrDelete()</code> method.
   * <p>This function replaces a range of text in a SpanElement as part of some hypothetical operation.</p>
   * <listing>
   *  import flashx.textLayout.elements.SpanElement;
   *
   *
   * function doReplace( span:SpanElement, newText:String, relativeStart:int, relativeEnd:int ):void
   * {
   *     span.replaceText(  relativeStart, relativeEnd, newText );
   *     var parentFlow:TextFlow = span.getTextFlow();
   *     var lengthDifference:int = newText.length - (relativeEnd - relativeStart);
   *
   *     parentFlow.interactionManager.notifyInsertOrDelete(    span.getAbsoluteStart() + relativeStart, lengthDifference );
   * }
   * </listing>
   */
  public native function notifyInsertOrDelete(absolutePosition:int, length:int):void;

  /**
   * Redisplays the selection shapes.
   * <p><b>Note:</b> You do not need to call this method directly. It is called automatically.</p>
   */
  public native function refreshSelection():void;

  /**
   *
   * @see flashx.textLayout.compose.IFlowComposer
   *
   */
  public native function selectAll():void;

  /**
   *
   * @param anchorPosition <code>anchorPosition:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/int.html">int</a></code>
   * @param activePosition <code>activePosition:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/int.html">int</a></code>
   *
   * @see flashx.textLayout.compose.IFlowComposer
   *
   */
  public native function selectRange(anchorPosition:int, activePosition:int):void;

  /**
   * Gives the focus to the first container in the selection.
   * @example The following example sets the focus to the first container in the current selection of a text flow. (The textFlow variable in the example is a TextFlow object.)
   * <listing>
   *  textFlow.interactionManager.setFocus();
   * </listing>
   */
  public native function setFocus():void;

  /**
   * Sets the SelectionState object of the current selection.
   * @param sel <code>sel:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flashx/textLayout/edit/SelectionState.html">SelectionState</a></code>
   *
   * @see SelectionState
   *
   */
  public native function setSelectionState(sel:SelectionState):void;

  /**
   * Processes a TextEvent.
   * @param event <code>event:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/TextEvent.html">flash.events:TextEvent</a></code>
   *
   */
  public native function textInputHandler(event:TextEvent):void;
}
}