package flashx.textLayout.operations {
import flashx.textLayout.edit.SelectionState;

/**
 * The ApplyLinkOperation class encapsulates a link creation or modification operation.
 * <p><a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flashx/textLayout/operations/ApplyLinkOperation.html#includeExamplesSummary">View the examples</a></p>
 * @see flashx.textLayout.elements.LinkElement
 * @see flashx.textLayout.edit.EditManager
 * @see flashx.textLayout.events.FlowOperationEvent
 *
 */
public class ApplyLinkOperation extends flashx.textLayout.operations.FlowTextOperation {
  /**
   * Whether to extend the selection to include the entire text of any existing links overlapped by the selection, and then apply the change.
   */
  public native function get extendToLinkBoundary():Boolean;

  /**
   * @private
   */
  public native function set extendToLinkBoundary(value:Boolean):void;

  /**
   * The URI to be associated with the link. If href is an empty string, the URI of links in the selection are removed.
   */
  public native function get href():String;

  /**
   * @private
   */
  public native function set href(value:String):void;

  /**
   * The target of the link.
   */
  public native function get target():String;

  /**
   * @private
   */
  public native function set target(value:String):void;

  /**
   * Creates an ApplyLinkOperation object.
   * @param operationState The text range to which the operation is applied.
   * @param href The URI to be associated with the link. If href is an empty string, the URI of links in the selection are removed.
   * @param target The target of the link.
   * @param extendToLinkBoundary Whether to extend the selection to include the entire text of any existing links overlapped by the selection, and then apply the change.
   *
   */
  public function ApplyLinkOperation(operationState:SelectionState, href:String, target:String, extendToLinkBoundary:Boolean){super(null);}
}
}