package flash.ui {


/**
 * The MouseCursor class is an enumeration of constant values used in setting the <code>cursor</code> property of the Mouse class.
 * @see Mouse#cursor
 *
 */
public final class MouseCursor {
  /**
   * Used to specify that the arrow cursor should be used.
   */
  public static const ARROW:String = "arrow";
  /**
   * Used to specify that the cursor should be selected automatically based on the object under the mouse.
   */
  public static const AUTO:String = "auto";
  /**
   * Used to specify that the button pressing hand cursor should be used.
   */
  public static const BUTTON:String = "button";
  /**
   * Used to specify that the dragging hand cursor should be used.
   */
  public static const HAND:String = "hand";
  /**
   * Used to specify that the I-beam cursor should be used.
   */
  public static const IBEAM:String = "ibeam";
}
}