package flashx.textLayout.compose {
import flash.text.engine.TextLine;

/**
 * The TextLineRecycler class provides support for recycling of TextLines. Some player versions support a recreateTextLine. Passing TextLines to the recycler makes them available for reuse. This improves Player performance.
 */
public class TextLineRecycler {
  /**
   * Controls if the TLF recycler enabled. It can only be enabled in 10.1 or later players.
   */
  public static native function get textLineRecyclerEnabled():Boolean;

  /**
   * @private
   */
  public static native function set textLineRecyclerEnabled(value:Boolean):void;

  /**
   * Add a TextLine to the pool for reuse. TextLines for reuse should have null userData and null parent.
   * @param textLine <code>textLine:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/text/engine/TextLine.html">flash.text.engine:TextLine</a></code>
   *
   */
  public static native function addLineForReuse(textLine:TextLine):void;

  /**
   * Return a TextLine from the pool for reuse.
   * @return <code><a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/text/engine/TextLine.html">flash.text.engine:TextLine</a></code>
   *
   */
  public static native function getLineForReuse():TextLine;
}
}