package flashx.textLayout.container {
import flash.display.Sprite;
import flash.events.ContextMenuEvent;
import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.FocusEvent;
import flash.events.IMEEvent;
import flash.events.KeyboardEvent;
import flash.events.MouseEvent;
import flash.events.TextEvent;
import flash.geom.Rectangle;
import flash.text.engine.TextLine;
import flash.ui.ContextMenu;

import flashx.textLayout.compose.ISWFContext;
import flashx.textLayout.edit.IEditManager;
import flashx.textLayout.edit.IInteractionEventHandler;
import flashx.textLayout.edit.ISelectionManager;
import flashx.textLayout.edit.SelectionFormat;
import flashx.textLayout.elements.IConfiguration;
import flashx.textLayout.elements.TextFlow;
import flashx.textLayout.formats.ITextLayoutFormat;
import flashx.undo.IUndoManager;

/**
 * Defines the value of the <code>type</code>
 * @eventType flashx.textLayout.events.FlowOperationEvent.FLOW_OPERATION_BEGIN
 */
[Event(name="flowOperationBegin", type="flashx.textLayout.events.FlowOperationEvent")]
/**
 * Defines the value of the <code>type</code>
 * @eventType flashx.textLayout.events.FlowOperationEvent.FLOW_OPERATION_COMPLETE
 */
[Event(name="flowOperationComplete", type="flashx.textLayout.events.FlowOperationEvent")]
/**
 * Defines the value of the <code>type</code>
 * @eventType flashx.textLayout.events.FlowOperationEvent.FLOW_OPERATION_END
 */
[Event(name="flowOperationEnd", type="flashx.textLayout.events.FlowOperationEvent")]

/**
 * Manages text in a container. Assumes that it manages all children of the container. Consider using TextContainerManager for better performance in cases where there is a one container per TextFlow, and the TextFlow is not the main focus, is static text, or is infrequently selected. Good for text in form fields, for example.
 * @see ContainerController
 *
 */
public class TextContainerManager extends flash.events.EventDispatcher implements flashx.textLayout.compose.ISWFContext, flashx.textLayout.edit.IInteractionEventHandler, flashx.textLayout.container.ISandboxSupport {
  /**
   * Returns the vertical extent allowed for text inside the container. The value is specified in pixels.
   * <p>After setting this property, the text in the container is damaged and requires composing.</p>
   */
  public native function get compositionHeight():Number;

  /**
   * @private
   */
  public native function set compositionHeight(value:Number):void;

  /**
   * Returns the horizontal extent allowed for text inside the container. The value is specified in pixels.
   * <p>After setting this property, the text in the container is damaged and requires composing.</p>
   */
  public native function get compositionWidth():Number;

  /**
   * @private
   */
  public native function set compositionWidth(value:Number):void;

  /**
   * The Configuration object for this TextContainerManager.
   *
   */
  public native function get configuration():IConfiguration;

  /**
   * Returns the container (DisplayObjectContainer) that holds the text that this TextContainerManager manages.
   * @see ContainerController#container
   *
   */
  public native function get container():Sprite;

  /**
   * The default configuration for this TextContainerManager. Column and padding attributes are set to <code>FormatValue.INHERIT</code>.
   * @see flashx.textLayout.elements.IConfiguration
   * @see flashx.textLayout.formats.FormatValue#INHERIT
   *
   */
  public static native function get defaultConfiguration():IConfiguration;

  /**
   * Editing mode of this TextContainerManager. Modes are reading only, reading and selection permitted, and editing (reading, selection, and writing) permitted. Use the constant values of the EditingMode class to set this property.
   * <p>Default value is READ_WRITE.</p>
   * @see flashx.textLayout.edit.EditingMode
   *
   */
  public native function get editingMode():String;

  /**
   * @private
   */
  public native function set editingMode(value:String):void;

  /**
   * Controls whether the factory generates all text lines or stops when the container bounds are filled.Specifies the horizontal scrolling policy, which you can set by assigning one of the constants of the ScrollPolicy class: ON, OFF, or AUTO.
   */
  public native function get horizontalScrollPolicy():String;

  /**
   * @private
   */
  public native function set horizontalScrollPolicy(value:String):void;

  /**
   * Specifies the current horizontal scroll location on the stage. The value specifies the number of pixels from the left.
   */
  public native function get horizontalScrollPosition():Number;

  /**
   * @private
   */
  public native function set horizontalScrollPosition(value:Number):void;

  /**
   * Sets the format when display just a string. If displaying a TextFlow this has no immediate effect. The supplied ITextLayoutFormat is not copied. Modifying it without calling this setter has indeterminate effects.
   */
  public native function get hostFormat():ITextLayoutFormat;

  /**
   * @private
   */
  public native function set hostFormat(value:ITextLayoutFormat):void;

  /**
   * The total number of lines in the flow.
   */
  public native function get numLines():int;

  /**
   * Optional ISWFContext instance used to make FTE calls as needed in the proper swf context.
   * @see flashx.textLayout.compose.ISWFContext
   *
   */
  public native function get swfContext():ISWFContext;

  /**
   * @private
   */
  public native function set swfContext(value:ISWFContext):void;

  /**
   * Controls whether the factory generates all text lines or stops when the container bounds are filled.Specifies the vertical scrolling policy, which you can set by assigning one of the constants of the ScrollPolicy class: ON, OFF, or, AUTO.
   */
  public native function get verticalScrollPolicy():String;

  /**
   * @private
   */
  public native function set verticalScrollPolicy(value:String):void;

  /**
   * Specifies the current vertical scroll location on the stage. The value specifies the number of pixels from the top.
   */
  public native function get verticalScrollPosition():Number;

  /**
   * @private
   */
  public native function set verticalScrollPosition(value:Number):void;

  /**
   * Constructor function - creates a TextContainerManager instance. For best results:<ol>
   * <li>Start with TextContainerManager.defaultConfiguration and modify it</li>
   * <li>Share the same Configuration among many InputManagers</li></ol>
   * @param container The DisplayObjectContainer in which to manage the text lines.
   * @param configuration - The IConfiguration instance to use with this TextContainerManager instance.
   *
   */
  public function TextContainerManager(container:Sprite, configuration:IConfiguration = null){super();}

  /**
   * Processes the <code>Event.ACTIVATE</code> event when the client manages events.
   * @param event The Event object.
   *
   * @see flash.events.Event#ACTIVATE
   *
   */
  public native function activateHandler(event:Event):void;

  /**
   * Returns the current ISelectionManager instance. Converts to TextFlow instance and creates one if necessary.
   * @return the interaction manager for this TextContainerManager instance.
   *
   * @see flashx.textLayout.edit.ISelectionManager
   *
   */
  public native function beginInteraction():ISelectionManager;

  /**
   * Called to request clients to begin the forwarding of mouseup and mousemove events from outside a security sandbox.
   */
  public native function beginMouseCapture():void;

  /**
   * Composes the container text; calls either the factory or <code>updateAllControllers()</code>.
   */
  public native function compose():void;

  /**
   * Creates a ContextMenu for the TextContainerManager. Use the methods of the ContextMenu class to add items to the menu.
   * <p>You can override this method to define a custom context menu.</p>
   * @return the created context menu.
   *
   * @see flash.ui.ContextMenu
   *
   */
  protected native function createContextMenu():ContextMenu;

  /**
   * Create an edit manager to use for editing. Override this method if you have a custom EditManager that you want to use in place of the default.
   * @param undoManager IUndoManager instance for the EditManager being created.
   *
   * @return the editing manager for this TextContainerManager instance.
   *
   */
  protected native function createEditManager(undoManager:IUndoManager):IEditManager;

  /**
   * Create a selection manager to use for selection. Override this method if you have a custom SelectionManager that you want to use in place of the default.
   * @return a new SelectionManager instance.
   *
   */
  protected native function createSelectionManager():ISelectionManager;

  /**
   * Processes the <code>Event.DEACTIVATE</code> event when the client manages events.
   * @param event The Event object.
   *
   * @see flash.events.Event#DEACTIVATE
   *
   */
  public native function deactivateHandler(event:Event):void;

  /**
   * Returns <code>true</code> if it has filled in the container's scrollRect property. This method enables you to test whether <code>scrollRect</code> is set without actually accessing the <code>scrollRect</code> property which can possibly create a performance issue.
   * <p>Override this method to draw a background or a border. Overriding this method can be tricky as the scrollRect <b>must</b> be set as specified.</p>
   * @param scrollX The starting horizontal position of the scroll rectangle.
   * @param scrollY The starting vertical position of the scroll rectangle.
   *
   * @return <code>true</code> if it has created the <code>scrollRect</code> object.
   *
   */
  public native function drawBackgroundAndSetScrollRect(scrollX:Number, scrollY:Number):Boolean;

  /**
   * Processes an edit event (CUT, COPY, PASTE, SELECT_ALL) when the client manages events.
   * @param event Event object.
   *
   * @see flash.events.Event
   *
   */
  public native function editHandler(event:Event):void;

  /**
   * Terminates interaction.
   * @see flashx.textLayout.edit.ISelectionManager
   *
   */
  public native function endInteraction():void;

  /**
   * Called to inform clients that the the forwarding of mouseup and mousemove events from outside a security sandbox is no longer needed.
   */
  public native function endMouseCapture():void;

  /**
   * Processes the <code>FocusEvent.KEY_FOCUS_CHANGE</code> and <code>FocusEvent.MOUSE_FOCUS_CHANGE</code> events when the client manages events.
   * @param event The FocusEvent object.
   *
   * @see flash.events.FocusEvent#KEY_FOCUS_CHANGE
   * @see flash.events.FocusEvent#MOUSE_FOCUS_CHANGE
   *
   */
  public native function focusChangeHandler(event:FocusEvent):void;

  /**
   * Process a focusIn event.
   * @param event <code>event:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/FocusEvent.html">FocusEvent</a></code>
   *
   */
  public native function focusInHandler(event:FocusEvent):void;

  /**
   * Processes the <code>FocusEvent.FOCUS_OUT</code> event when the client manages events.
   * @param event The FocusEvent object.
   *
   * @see flash.events.FocusEvent#FOCUS_OUT
   *
   */
  public native function focusOutHandler(event:FocusEvent):void;

  /**
   * Creates a rectangle that shows where the last call to either the <code>compose()</code> method or the <code>updateContainer()</code> method placed the text.
   * @return the bounds of the content
   *
   * @see #compose()
   * @see #updateContainer()
   *
   */
  public native function getContentBounds():Rectangle;

  /**
   * Returns the focusedSelectionFormat - by default get it from the configuration. This can be overridden in the subclass to supply a different SelectionFormat
   * @return <code><a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flashx/textLayout/edit/SelectionFormat.html">SelectionFormat</a></code>
   *
   */
  protected native function getFocusedSelectionFormat():SelectionFormat;

  /**
   * Returns the inactiveSelectionFormat - by default get it from the configuration This can be overridden in the subclass to supply a different SelectionFormat
   * @return <code><a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flashx/textLayout/edit/SelectionFormat.html">SelectionFormat</a></code>
   *
   */
  protected native function getInactiveSelectionFormat():SelectionFormat;

  /**
   * Return the TextLine at the index from array of composed lines.
   * @param index Finds the line at this index position in the text.
   *
   * @return the TextLine that occurs at the specified index.
   *
   */
  public native function getLineAt(index:int):TextLine;

  /**
   * Figure out the scroll distance required to scroll up or down by the specified number of lines. Negative numbers scroll upward, bringing more of the top of the TextFlow into view. Positive numbers scroll downward, bringing the next line from the bottom into full view.
   * <p>When scrolling up, for example, the method makes the next line fully visible. If the next line is partially obscured and the number of lines specified is 1, the partially obscured line becomes fully visible.</p>
   * @param numLines The number of lines to scroll.
   *
   * @return the delta amount of space to scroll
   *
   */
  public native function getScrollDelta(numLines:int):Number;

  /**
   * Returns the current text using a separator between paragraphs. The separator can be specified with the <code>separator</code> argument. The default value of the <code>separator</code> argument is the Unicode character <code>'PARAGRAPH SEPARATOR' (U+2029)</code>.
   * <p>Calling the setter discards any attached TextFlow. Any selection is lost.</p>
   * @param separator String to set between paragraphs.
   *
   * @return <code><a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/String.html">String</a></code>
   *
   */
  public native function getText(separator:String = ""):String;

  /**
   * The current TextFlow. Converts this to a full TextFlow representation if it isn't already one.
   * @return the current TextFlow object
   *
   */
  public native function getTextFlow():TextFlow;

  /**
   * Returns the undo manager to use. By default, creates a unique undo manager. You can override this method in the subclass if you want to customize the undo manager (for example, to use a shared undo manager for multiple TextContainerManager instances).
   * @return new IUndoManager instance.
   *
   */
  protected native function getUndoManager():IUndoManager;

  /**
   * Returns the unfocusedSelectionFormat - by default get it from the configuration You can override this method in the subclass to supply a different SelectionFormat.
   * @return <code><a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flashx/textLayout/edit/SelectionFormat.html">SelectionFormat</a></code>
   *
   */
  protected native function getUnfocusedSelectionFormat():SelectionFormat;

  /**
   * Processes the <code>IME_START_COMPOSITION</code> event when the client manages events.
   * @param event The IMEEvent object.
   *
   * @see flash.events.IMEEvent#IME_START_COMPOSITION
   *
   */
  public native function imeStartCompositionHandler(event:IMEEvent):void;

  /**
   * Call this if you change the selection formats (SelectionFormat) and want the interactionManager to update.
   */
  public native function invalidateSelectionFormats():void;

  /**
   * Call this if you are editing, and want to reset the undo manager used for editing.
   */
  public native function invalidateUndoManager():void;

  /**
   * Returns <code>true</code> if the content needs composing.
   * @return <code>true</code> if the content needs composing; <code>false</code> otherwise.
   *
   */
  public native function isDamaged():Boolean;

  /**
   * Processes the <code>KeyboardEvent.KEY_DOWN</code> event when the client manages events.
   * @param event KeyboardEvent object.
   *
   * @see flash.events.KeyboardEvent#KEY_DOWN
   *
   */
  public native function keyDownHandler(event:KeyboardEvent):void;

  /**
   * Processes the <code>FocusEvent.KEY_FOCUS_CHANGE</code> event when the client manages events.
   * @param event The FocusEvent object.
   *
   */
  public native function keyFocusChangeHandler(event:FocusEvent):void;

  /**
   * Processes the <code>Keyboard.KEY_UP</code> event when the client manages events.
   * @param event The KeyboardEvent object.
   *
   * @see flash.events.KeyboardEvent#KEY_UP
   *
   */
  public native function keyUpHandler(event:KeyboardEvent):void;

  /**
   * Processes the <code>ContextMenuEvent.MENU_SELECT</code> event when the client manages events.
   * @param event ContextMenuEvent object.
   *
   * @see flash.events.ContextMenuEvent#MENU_SELECT
   *
   */
  public native function menuSelectHandler(event:ContextMenuEvent):void;

  /**
   * Processes the <code>MouseEvent.DOUBLE_CLICK</code> event when the client manages events.
   * @param event The MouseEvent object.
   *
   * @see flash.events.MouseEvent#DOUBLE_CLICK
   *
   */
  public native function mouseDoubleClickHandler(event:MouseEvent):void;

  /**
   * Processes the <code>MouseEvent.MOUSE_DOWN</code> event when the client manages events.
   * @param event The MouseEvent object.
   *
   * @see flash.events.MouseEvent#MOUSE_DOWN
   *
   */
  public native function mouseDownHandler(event:MouseEvent):void;

  /**
   * Processes the <code>MouseEvent.MOUSE_MOVE</code> event when the client manages events.
   * @param event The MouseEvent object.
   *
   * @see flash.events.MouseEvent#MOUSE_MOVE
   *
   */
  public native function mouseMoveHandler(event:MouseEvent):void;

  /**
   * Client call to forward a mouseMove event from outside a security sandbox. Coordinates of the mouse move are not needed.
   * @param e <code>e:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/Event.html">Event</a></code>
   *
   */
  public native function mouseMoveSomewhere(e:Event):void;

  /**
   * Processes the <code>MouseEvent.MOUSE_OUT</code> event when the client manages events.
   * @param event The MouseEvent object.
   *
   * @see flash.events.MouseEvent#MOUSE_OUT
   *
   */
  public native function mouseOutHandler(event:MouseEvent):void;

  /**
   * Process a mouseOver event.
   * @param event <code>event:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/MouseEvent.html">MouseEvent</a></code>
   *
   * @see flash.events.MouseEvent#MOUSE_OVER
   *
   */
  public native function mouseOverHandler(event:MouseEvent):void;

  /**
   * Processes the <code>MouseEvent.MOUSE_UP</code> event when the client manages events.
   * @param event The MouseEvent object.
   *
   * @see flash.events.MouseEvent#MOUSE_UP
   *
   */
  public native function mouseUpHandler(event:MouseEvent):void;

  /**
   * Client call to forward a mouseUp event from outside a security sandbox. Coordinates of the mouse up are not needed.
   * @param e <code>e:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/Event.html">Event</a></code>
   *
   */
  public native function mouseUpSomewhere(e:Event):void;

  /**
   * Processes the <code>MouseEvent.MOUSE_WHEEL</code> event when the client manages events.
   * @param event The MouseEvent object.
   *
   * @see flash.events.MouseEvent#MOUSE_WHEEL
   *
   */
  public native function mouseWheelHandler(event:MouseEvent):void;

  /**
   * Scrolls so that the text range is visible in the container.
   * @param activePosition The end of the selection that is changed when you extend the selection. It can be either the start or the end of the selection, expressed as an offset from the start of the text flow.
   * @param anchorPosition The stable end of the selection when you extend the selection. It can be either the start or the end of the selection.
   *
   */
  public native function scrollToRange(activePosition:int, anchorPosition:int):void;

  /**
   * Sets the <code>text</code> property to the specified String. Discards any attached TextFlow. Any selection is lost.
   * @param text the String to set
   *
   */
  public native function setText(text:String):void;

  /**
   * Sets a TextFlow into this TextContainerManager replacing any existing TextFlow and discarding the current text.
   * @param textFlow <code>textFlow:<a href="http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flashx/textLayout/elements/TextFlow.html">flashx.textLayout.elements:TextFlow</a></code>
   *
   */
  public native function setTextFlow(textFlow:TextFlow):void;

  /**
   * Processes the <code>TextEvent.TEXT_INPUT</code> event when the client manages events.
   * @param event The TextEvent object.
   *
   * @see flash.events.TextEvent#TEXT_INPUT
   *
   */
  public native function textInputHandler(event:TextEvent):void;

  /**
   * Updates the display; calls either the factory or updateAllControllers().
   */
  public native function updateContainer():void;

  /**
   * Dispatched when any link is clicked.
   */
  /**
   * Dispatched after every recompose.
   */
  /**
   * Dispatched by a TextFlow object each time it is damaged
   */
  /**
   * Dispatched when a InlineGraphicElement is resized due to having width or height as auto or percent and the graphic has finished loading.
   */
  /**
   * Dispatched when the mouse is pressed down over any link.
   */
  /**
   * Dispatched when the mouse passes over any link.
   */
  /**
   * Dispatched when the mouse is released over any link.
   */
  /**
   * Dispatched when the mouse goes out of any link.
   */
  /**
   * Dispatched when the mouse first enters any link.
   */
  /**
   * Dispatched by a TextFlow object after text is scrolled within a controller container.
   */
  /**
   * Dispatched whenever the selection is changed. Primarily used to update selection-dependent user interface.
   */
  /**
   * Dispatched by a TextFlow object each time a container has had new DisplayObjects added or updated as a result of composition.
   */


  public native function callInContext(fn:Function, thisArg:Object, argArray:Array, returns:Boolean = true):*;
}
}