package flashx.textLayout.operations {
import flashx.textLayout.edit.SelectionState;

/**
 * The DeleteTextOperation class encapsulates the deletion of a range of text.
 * @see flashx.textLayout.edit.EditManager
 * @see flashx.textLayout.events.FlowOperationEvent
 *
 */
public class DeleteTextOperation extends flashx.textLayout.operations.FlowTextOperation {
  /**
   * Indicates whether this operation can be merged with operations executed before or after it.
   * <p>Some delete operations, for example, a sequence of backspace keystrokes, can be fruitfully merged into one operation so that undoing the operation reverses the entire sequence.</p>
   */
  public native function get allowMerge():Boolean;

  /**
   * @private
   */
  public native function set allowMerge(value:Boolean):void;

  /**
   * deleteSelectionState The range of text to delete
   */
  public native function get deleteSelectionState():SelectionState;

  /**
   * @private
   */
  public native function set deleteSelectionState(value:SelectionState):void;

  /**
   * Creates a DeleteTextOperation operation.
   * @param operationState The original range of text.
   * @param deleteSelectionState The range of text to delete, if different from the range described by <code>operationState</code>. (Set to <code>null</code> to delete the range described by <code>operationState</code>.)
   * @param allowMerge Set to <code>true</code> if this operation can be merged with the next or previous operation.
   *
   */
  public function DeleteTextOperation(operationState:SelectionState, deleteSelectionState:SelectionState = null, allowMerge:Boolean = false){super(null);}
}
}