package flashx.textLayout.operations {
import flashx.textLayout.edit.SelectionState;
import flashx.textLayout.edit.TextScrap;

/**
 * The PasteOperation class encapsulates a paste operation.
 * <p>The specified range is replaced by the new content.</p>
 * <p><b>Note:</b> The edit manager is responsible for copying the contents of the clipboard.</p>
 * @see flashx.textLayout.edit.EditManager
 * @see flashx.textLayout.events.FlowOperationEvent
 *
 */
public class PasteOperation extends flashx.textLayout.operations.FlowTextOperation {
  /**
   * textScrap the text being pasted
   */
  public native function get textScrap():TextScrap;

  /**
   * @private
   */
  public native function set textScrap(value:TextScrap):void;

  /**
   * Creates a PasteOperation object.
   * @param operationState Describes the insertion point or a range of text to replace.
   * @param textScrap The content to paste into the text flow.
   *
   */
  public function PasteOperation(operationState:SelectionState, textScrap:TextScrap){super(null);}
}
}