/*
   Copyright (c) 2008. Adobe Systems Incorporated.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:

     * Redistributions of source code must retain the above copyright notice,
       this list of conditions and the following disclaimer.
     * Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
     * Neither the name of Adobe Systems Incorporated nor the names of its
       contributors may be used to endorse or promote products derived from this
       software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE.
*/
package flexunit.framework
{
   import mx.utils.ObjectUtil;
   import mx.utils.StringUtil;
   
   /**
    * Base class containing static assert methods.
    */
   public class Assert
   {
      protected static var _assertionsMade : Number = 0;

      public static native function resetAssertionsMade() : void;
      
      public static native function oneAssertionHasBeenMade() : void;

      public static native function resetEveryAsserionsFields() : void;
            
      public static native function get maxAssertionsMade() : Number;
      
      public static native function get assetionsMade() : Number;
      
      public static native function get totalAssertionsMade() : Number;
      
      public function Assert(){super();}

   //---------------------------------------------------------------------------


      /**
       * Asserts that 2 values are equal.
       * The first argument can be the message when the assertion fails
       *
       * @param rest [ message = "", expected, actual ]
       *
       */
      public static native function assertEquals( ... rest ) : void;
      
   //---------------------------------------------------------------------------


      /**
       * Asserts that 2 objects are equal.
       * This method will recursively compare properties on the nested objects.
       * The first argument can be the message when the assertion fails
       *
       * @param rest [ message = "", expected, actual ]
       *
       */
      public static native function assertObjectEquals( ... rest ) : void; 


   //---------------------------------------------------------------------------

      /**
       * Asserts that a string matches a regexp.
       * The first argument can be the message when the assertion fails
       *
       * @param rest [ message = "", regexp, stringToTest ]
       *
       */
      public static native function assertMatch( ... rest ) : void;

   //---------------------------------------------------------------------------

      /**
       * Asserts that a string doesn't match a regexp.
       * The first argument can be the message when the assertion fails
       *
       * @param rest [ message = "", regexp, stringToTest ]
       *
       */
      public static native function assertNoMatch( ... rest ) : void;

   //---------------------------------------------------------------------------

      /**
       * Asserts that the first string is contained in the second one
       * The first argument can be the message when the assertion fails
       *
       * @param rest [ message = "", shortString, longString ]
       *
       */
      public static native function assertContained( ... rest ) : void;

   //---------------------------------------------------------------------------

      /**
       * Asserts that the first string is not contained in the second one
       * The first argument can be the message when the assertion fails
       *
       * @param rest [ message = "", shortString, longString ]
       *
       */
      public static native function assertNotContained( ... rest ) : void;

   //---------------------------------------------------------------------------

      /**
       * Asserts that two objects are strickly identical
       * The first argument can be the message when the assertion fails
       *
       * @param rest [ message = "", expectedObject, actualObject ]
       *
       */
      public static native function assertStrictlyEquals( ... rest ) : void;

   //---------------------------------------------------------------------------

      /**
       * Asserts that a condition is true
       * The first argument can be the message when the assertion fails
       *
       * @param rest [ message = "", condition ]
       *
       */
      public static native function assertTrue( ... rest ) : void;

   //---------------------------------------------------------------------------

      /**
       * Asserts that a condition is false
       * The first argument can be the message when the assertion fails
       *
       * @param rest [ message = "", condition ]
       *
       */
      public static native function assertFalse( ... rest ) : void;

   //---------------------------------------------------------------------------

      /**
       * Asserts that an object is null
       * The first argument can be the message when the assertion fails
       *
       * @param rest [ message = "", objectToTest ]
       *
       */
      public static native function assertNull( ... rest ) : void;

   //---------------------------------------------------------------------------

      /**
       * Asserts that an object is not null
       * The first argument can be the message when the assertion fails
       *
       * @param rest [ message = "", objectToTest ]
       *
       */
      public static native function assertNotNull( ... rest ) : void;

   //---------------------------------------------------------------------------

      /**
       * Asserts that an object is undefined
       * The first argument can be the message when the assertion fails
       *
       * @param rest [ message = "", objectToTest ]
       *
       */
      public static native function assertUndefined( ... rest ) : void;

   //---------------------------------------------------------------------------

      /**
       * Asserts that an object is not undefined
       * The first argument can be the message when the assertion fails
       *
       * @param rest [ message = "", objectToTest ]
       *
       */
      public static native function assertNotUndefined( ... rest ) : void;

   //---------------------------------------------------------------------------

      /**
       * Fails with the given message
       *
       * @param failMessage
       */
      public static native function fail( failMessage : String = "" ) : void;
   }
}