joo.classLoader.prepare(/*

Copyright (c) 2008. Adobe Systems Incorporated.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

  * Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
  * Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.
  * Neither the name of Adobe Systems Incorporated nor the names of its
    contributors may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

@ignore
*/

"package flexunit.framework",/*
{
   import flash.events.Event

   import mx.collections.ArrayCollection
   import mx.collections.ListCollectionView*/

   /**
    * Listens for expected events, keeping track of the expected events that
    * actually occur. A helper class designed specifically for the
    * <code>EventfulTestCase</code>.
    */
   "internal class EventfulTestCaseListener",1,function($$private){var as=joo.as;return[
   
      //-------------------------------
      //
      // properties
      //
      //-------------------------------

      "private var",{ _expectedEventTypes/* : ListCollectionView*/
               :function(){return( new mx.collections.ArrayCollection());}},
      "private var",{ _unexpectedEventTypes/* : ListCollectionView*/
               :function(){return( new mx.collections.ArrayCollection());}},

      "private var",{ _dispatchedExpectedEvents/* : ListCollectionView*/
               :function(){return( new mx.collections.ArrayCollection());}},

      /**
       * Gets a comma-separated string listing the types of events that were
       * expected.
       */
      "public function get expectedEventTypes",function expectedEventTypes$get()/* : String*/
      {
         var eventTypes/* : String*/ = "";

        for ( var i/*: uint*/ = 0; i < this._expectedEventTypes$1.length; i++ )
         {
            eventTypes +=as( this._expectedEventTypes$1[ i ],  String);

            if ( i < this._expectedEventTypes$1.length - 1 )
            {
               eventTypes += ',';
            }
         }

         return eventTypes;
      },

      /**
       * Gets a comma-separated string listing the types of events that were not
       * expected.
       */
      "public function get unexpectedEventTypes",function unexpectedEventTypes$get()/* : String*/
      {
         var eventTypes/* : String*/ = "";

         for ( var i/*: uint*/ = 0; i < this._unexpectedEventTypes$1.length; i++ )
         {
            eventTypes +=as( this._unexpectedEventTypes$1[ i ],  String);

            if ( i < this._unexpectedEventTypes$1.length - 1 )
            {
               eventTypes += ',';
            }
         }

         return eventTypes;
      },

      /**
       * Gets a comma-separated string listing the types of events that have
       * been heard.
       */
      "public function get dispatchedExpectedEventTypes",function dispatchedExpectedEventTypes$get()/* : String*/
      {
         var eventTypes/* : String*/ = "";

         for ( var i/*: uint*/; i < this._dispatchedExpectedEvents$1.length; i++ )
         {
            var event/* : Event*/ =as( this._dispatchedExpectedEvents$1[ i ],  flash.events.Event);

            eventTypes += event.type;

            if ( i < this._dispatchedExpectedEvents$1.length - 1 )
            {
               eventTypes += ',';
            }
         }

         return eventTypes;
      },

      /**
       * Gets an array of all the events that have been heard.
       */
      "public function get dispatchedExpectedEvents",function dispatchedExpectedEvents$get()/* : Array*/
      {
         return this._dispatchedExpectedEvents$1.toArray();
      },

      /**
       * Gets the last event to have been heard.
       */
      "public function get lastDispatchedExpectedEvent",function lastDispatchedExpectedEvent$get()/* : Event*/
      {
         if ( this._dispatchedExpectedEvents$1.length == 0 )
         {
            return null;
         }

         return/* flash.events.Event*/( this._dispatchedExpectedEvents$1.getItemAt( this._dispatchedExpectedEvents$1.length - 1 ) );
      },

      //-------------------------------
      //
      // constructor
      //
      //-------------------------------

      "public function EventfulTestCaseListener",function EventfulTestCaseListener$()
      {this._expectedEventTypes$1=this._expectedEventTypes$1();this._unexpectedEventTypes$1=this._unexpectedEventTypes$1();this._dispatchedExpectedEvents$1=this._dispatchedExpectedEvents$1();
         this._dispatchedExpectedEvents$1 = new mx.collections.ArrayCollection();
         this._expectedEventTypes$1 = new mx.collections.ArrayCollection();
      },

      //-------------------------------
      //
      // functions
      //
      //-------------------------------

      /**
       * Records an event being listened for.
       *
       * @param type
       *    the type of event
       * @param expected
       *    whether the event is expected to be dispatched or not
       */
      "public function listenForEvent",function listenForEvent( type/* : String*/, expected/* : Boolean*/ )/* : void*/
      {
      	if ( expected )
	         this._expectedEventTypes$1.addItem( type );
	      else
         	this._unexpectedEventTypes$1.addItem( type );
      },

      /**
       * Verifies that the expected events were heard, returning
       * <code>true</code> if so or <code>false</code> otherwise.
       */
      "public function expectedEventsDispatched",function expectedEventsDispatched()/* : Boolean*/
      {
        for (var i/*:uint*/ = 0; i < this._expectedEventTypes$1.length; ++i )
         {
            var expectedEvent/* : String*/ = this._expectedEventTypes$1[i];
         	if ( this.expectedEventDispatched( expectedEvent ) == false )
         		return false;
         }
         return true;
      },

      /**
      *  Verifies the expected event was dispatched
      */
      "public function expectedEventDispatched",function expectedEventDispatched( expectedEvent/* : String*/ )/* : Boolean*/
      {
      	for (var i/*:uint*/ = 0; i < this._dispatchedExpectedEvents$1.length; ++i )
        	{
              var actualEvent/* : Event*/ = this._dispatchedExpectedEvents$1[i];
            if ( actualEvent.type == expectedEvent )
            {
               return true;
            }
         }
         return false;
      },

      /**
       * Verifies that the unexpected events were not heard, returning
       * <code>true</code> if so or <code>false</code> otherwise.
       */
      "public function unexpectedEventsNotDispatched",function unexpectedEventsNotDispatched()/* : Boolean*/
      {
         for (var i/*:uint*/ = 0; i < this._unexpectedEventTypes$1.length; ++i )
         {
            var unexpectedEvent/* : String*/ = this._unexpectedEventTypes$1[i];
         	if ( this.unexpectedEventNotDispatched( unexpectedEvent ) == false )
         	{
         		return false;
         	}
         }

         return true;
      },

      /**
      *  Verifies that the unexpected event was not dispatched
      */
      "public function unexpectedEventNotDispatched",function unexpectedEventNotDispatched( unexpectedEvent/* : String*/ )/* : Boolean*/
      {
	      for (var i/*:uint*/ = 0; i < this._dispatchedExpectedEvents$1.length; ++i )
         {
            var actualEvent/* : Event*/ = this._dispatchedExpectedEvents$1[i];
            if( actualEvent.type == unexpectedEvent )
            {
               return false;
            }
         }

         return true;
      },

      /**
       * Handles an event by recording that it actually occurred.
       */
      "public function handleEvent",function handleEvent( event/* : Event*/ )/* : void*/
      {
         this._dispatchedExpectedEvents$1.addItem( event );
      },
   ];},[],["mx.collections.ArrayCollection","String","flash.events.Event"], "0.8.0", "0.8.3"
);