joo.classLoader.prepare(/*
   Copyright (c) 2008. Adobe Systems Incorporated.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:

     * Redistributions of source code must retain the above copyright notice,
       this list of conditions and the following disclaimer.
     * Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
     * Neither the name of Adobe Systems Incorporated nor the names of its
       contributors may be used to endorse or promote products derived from this
       software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE.
*/

"package flexunit.framework",/*
{
   import flash.events.*;
   import flash.utils.*;
   
   import mx.utils.StringUtil;*/

   "public class AsyncTestHelper",1,function($$private){var $$bound=joo.boundMethod;return[function(){joo.classLoader.init(flexunit.framework.AssertStringFormats,flash.events.TimerEvent);},
   
       "public function AsyncTestHelper",function AsyncTestHelper$( testCase/* : TestCase*/, testResult/* : TestResult*/ )
       {
           this.testCase$1 = testCase;
           this.testResult$1 = testResult;
           this.timer$1 = new flash.utils.Timer( 100 );
           this.timer$1.addEventListener( flash.events.TimerEvent.TIMER, $$bound(this,"timerHandler") );
       },

   //------------------------------------------------------------------------------

       "public function startAsync",function startAsync()/* : void*/
       {
           this.loadAsync();
           if ( this.objToPass$1 != null )
           {
               this.testResult$1.continueRun( this.testCase$1 );
           }
           else
           {
               this.timer$1.start();
           }
       },

   //------------------------------------------------------------------------------


       "public function loadAsync",function loadAsync()/* : void*/
       {
           var async/* : Object*/ = this.testCase$1.getNextAsync();

           this.func$1 = async.func;

           this.extraData$1 = async.extraData;

           this.failFunc$1 = async.failFunc;

           //BUG 114824 WORKAROUND
           this.timer$1 = new flash.utils.Timer( async.timeout, 1 );

           this.timer$1.addEventListener( flash.events.TimerEvent.TIMER, $$bound(this,"timerHandler") );
           //END WORKAROUND

           this.timer$1.delay = async.timeout;
       },

   //------------------------------------------------------------------------------

       "public function runNext",function runNext()/* : void*/
       {
           if ( this.shouldFail$1 )
           {
               if ( this.failFunc$1 != null )
               {
                   this.failFunc$1( this.extraData$1 );
               }
               else
               {
                   flexunit.framework.Assert.fail( mx.utils.StringUtil.substitute( flexunit.framework.AssertStringFormats.ASYNC_CALL_NOT_FIRED, this.timer$1.delay ) );
               }
           }
           else
           {
               if ( this.extraData$1 != null )
               {
                   this.func$1( this.objToPass$1, this.extraData$1 );
               }
               else
               {
                   this.func$1( this.objToPass$1 );
               }
               this.func$1 = null;
               this.objToPass$1 = null;
               this.extraData$1 = null;
           }
       },

   //------------------------------------------------------------------------------

       "public function timerHandler",function timerHandler( event/* : TimerEvent*/ )/* : void*/
       {
           this.timer$1.stop();
           this.shouldFail$1 = true;
           this.testResult$1.continueRun( this.testCase$1 );
       },

   //------------------------------------------------------------------------------

       "public function handleEvent",function handleEvent( event/* : Object*/ )/* : void*/
       {
           var wasReallyAsync/* : Boolean*/ = this.timer$1.running;

           this.timer$1.stop();

           if ( this.shouldFail$1 )
               return;

           this.objToPass$1 = event;
           if ( wasReallyAsync )
           {
               this.testResult$1.continueRun( this.testCase$1 );
           }
       },

   //------------------------------------------------------------------------------

       //IResponder methods here (they'd look similar to handleEvent) ...

   //------------------------------------------------------------------------------

       "private var",{ testCase/* : TestCase*/:null},
       "private var",{ func/* : Function*/:null},
       "private var",{ extraData/* : Object*/:null},
       "private var",{ failFunc/* : Function*/:null},
       "private var",{ testResult/* : TestResult*/:null},

       "private var",{ shouldFail/* : Boolean*/ : false},
       "private var",{ objToPass/* : Object*/:null},

       "private var",{ timer/* : Timer*/:null},

   ];},[],["flash.utils.Timer","flash.events.TimerEvent","flexunit.framework.Assert","mx.utils.StringUtil","flexunit.framework.AssertStringFormats"], "0.8.0", "0.9.1"
);