/*
   Copyright (c) 2008. Adobe Systems Incorporated.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:

     * Redistributions of source code must retain the above copyright notice,
       this list of conditions and the following disclaimer.
     * Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
     * Neither the name of Adobe Systems Incorporated nor the names of its
       contributors may be used to endorse or promote products derived from this
       software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE.
*/

package flexunit.framework
{

   import flexunit.utils.*;

   /**
    * A <code>TestResult</code> collects the results of an executing
    * Test. It is an instance of the Collecting Parameter pattern.
    * The test framework distinguishes between <i>failures</i> and <i>errors</i>.
    * A failure is anticipated and checked for with assertions. Errors are
    * unanticipated problems.
    *
    * @see flexunit.framework.Test
    */
   public class TestResult
   {
      public var syncToFrame : Boolean = false;

      public function TestResult(){super();}

   //------------------------------------------------------------------------------

      public native function run( testCase : TestCase ) : void;

   //------------------------------------------------------------------------------

       //called by the AsyncTestHelper when it has either failed or received the callback
      public native function continueRun( testCase : TestCase ) : void;

   //------------------------------------------------------------------------------

      public native function addError( test : Test, error : Error ) : void;

   //------------------------------------------------------------------------------

      public native function addFailure( test : Test, error : AssertionFailedError ) : void;

   //------------------------------------------------------------------------------

      public native function errorCount() : Number;

   //------------------------------------------------------------------------------

      public native function errorsIterator() : Iterator;

   //------------------------------------------------------------------------------

      public native function failureCount() : Number;

   //------------------------------------------------------------------------------

      public native function failuresIterator() : Iterator;

   //------------------------------------------------------------------------------

      public native function shouldStop() : Boolean;

   //------------------------------------------------------------------------------

      public native function stop( stopTests : Boolean ) : void;

   //------------------------------------------------------------------------------

      public native function wasSuccessful() : Boolean;

   //------------------------------------------------------------------------------

      public native function addListener( listener : TestListener ) : void;

   //------------------------------------------------------------------------------

      public native function removeListener( listener : TestListener ) : void;

   //------------------------------------------------------------------------------

      public native function runCount() : Number;

   //------------------------------------------------------------------------------

      public native function startTest( test : Test ) : void;

   //------------------------------------------------------------------------------

      public native function endTest( test : Test ) : void;

   //------------------------------------------------------------------------------
   
      public native function get assertionsMade() : Number;
   }
}