joo.classLoader.prepare(/*
   Copyright (c) 2008. Adobe Systems Incorporated.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:

     * Redistributions of source code must retain the above copyright notice,
       this list of conditions and the following disclaimer.
     * Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
     * Neither the name of Adobe Systems Incorporated nor the names of its
       contributors may be used to endorse or promote products derived from this
       software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE.
*/

"package flexunit.framework",/*
{

   import flexunit.utils.*;*/

   /**
    * A <code>TestResult</code> collects the results of an executing
    * Test. It is an instance of the Collecting Parameter pattern.
    * The test framework distinguishes between <i>failures</i> and <i>errors</i>.
    * A failure is anticipated and checked for with assertions. Errors are
    * unanticipated problems.
    *
    * @see flexunit.framework.Test
    */
   "public class TestResult",1,function($$private){var is=joo.is;return[function(){joo.classLoader.init(flexunit.framework.Assert);},
   
      "public var",{ syncToFrame/* : Boolean*/ : false},

      "public function TestResult",function TestResult$()
      {
         this.failures$1 =/* flexunit.utils.Collection*/( new flexunit.utils.ArrayList() );
         this.errors$1 =/* flexunit.utils.Collection*/( new flexunit.utils.ArrayList() );
         this.listeners$1 =/* flexunit.utils.Collection*/( new flexunit.utils.ArrayList() );

         this.runTests$1 = 0;
      },

   //------------------------------------------------------------------------------

      "public function run",function run( testCase/* : TestCase*/ )/* : void*/
      {
         /*if ( syncToFrame )
            FunctionCallQueue.getInstance().call( this, doRun, [ testCase ] );
         else
         */
            this.doRun$1( testCase );
      },

   //------------------------------------------------------------------------------

       //called by the AsyncTestHelper when it has either failed or received the callback
      "public function continueRun",function continueRun( testCase/* : TestCase*/ )/* : void*/
      {
           this.doContinue$1( testCase );
      },

   //------------------------------------------------------------------------------

      "private function doRun",function doRun( testCase/* : TestCase*/ )/* : void*/
      {
         this.startTest( testCase );

         testCase.setTestResult( this );

         var protectedTestCase/* : Protectable*/ =/* flexunit.framework.Protectable*/( new flexunit.framework.ProtectedStartTestCase( testCase ) );

         var startOK/* : Boolean*/ = this.doProtected$1( testCase, protectedTestCase );

         if ( startOK )
         {
              this.doContinue$1( testCase );
         }
         else
         {
             this.endTest( testCase );             
         }
         
         testCase.assertionsMade = this.assertionsMade;
      },

   //------------------------------------------------------------------------------
      "private function doContinue",function doContinue( testCase/* : TestCase*/ )/* : void*/
      {
           var protectedTestCase/* : Protectable*/ =/* flexunit.framework.Protectable*/( new flexunit.framework.ProtectedMiddleTestCase ( testCase ) );
           this.doProtected$1( testCase, protectedTestCase );
           if ( testCase.hasAsync() )
           {
               testCase.startAsync();
           }
           else
           {
               this.doFinish$1( testCase );
           }
      },

   //------------------------------------------------------------------------------

      "private function doFinish",function doFinish( testCase/* : TestCase*/ )/* : void*/
      {
         var protectedTestCase/* : Protectable*/ =/* flexunit.framework.Protectable*/( new flexunit.framework.ProtectedFinishTestCase( testCase ) );

         this.doProtected$1( testCase, protectedTestCase );
         this.endTest( testCase );
      },

   //------------------------------------------------------------------------------

      "public function addError",function addError( test/* : Test*/, error/* : Error*/ )/* : void*/
      {
         this.errors$1.addItem( new flexunit.framework.TestFailure( test, error ) );

         var iter/* : Iterator*/ = this.listeners$1.iterator();
         while ( iter.hasNext() )
         {
            var listener/* : TestListener*/ =/* flexunit.framework.TestListener*/( iter.next() );
            listener.addError( test, error );
         }
      },

   //------------------------------------------------------------------------------

      "public function addFailure",function addFailure( test/* : Test*/, error/* : AssertionFailedError*/ )/* : void*/
      {
         this.failures$1.addItem( new flexunit.framework.TestFailure( test, error ) );

         var iter/* : Iterator*/ = this.listeners$1.iterator();
         while ( iter.hasNext() )
         {
            var listener/* : TestListener*/ =/* flexunit.framework.TestListener*/( iter.next() );
            listener.addFailure( test, error );
         }
      },

   //------------------------------------------------------------------------------

      "public function errorCount",function errorCount()/* : Number*/
      {
         return this.errors$1.length();
      },

   //------------------------------------------------------------------------------

      "public function errorsIterator",function errorsIterator()/* : Iterator*/
      {
         return this.errors$1.iterator();
      },

   //------------------------------------------------------------------------------

      "public function failureCount",function failureCount()/* : Number*/
      {
         return this.failures$1.length();
      },

   //------------------------------------------------------------------------------

      "public function failuresIterator",function failuresIterator()/* : Iterator*/
      {
         return this.failures$1.iterator();
      },

   //------------------------------------------------------------------------------

      "public function shouldStop",function shouldStop()/* : Boolean*/
      {
         return this.stopTests$1;
      },

   //------------------------------------------------------------------------------

      "public function stop",function stop( stopTests/* : Boolean*/ )/* : void*/
      {
         this.stopTests$1 = stopTests;
      },

   //------------------------------------------------------------------------------

      "public function wasSuccessful",function wasSuccessful()/* : Boolean*/
      {
         return this.failureCount() == 0 && this.errorCount() == 0;
      },

   //------------------------------------------------------------------------------

      "public function addListener",function addListener( listener/* : TestListener*/ )/* : void*/
      {
         if ( this.listeners$1.contains( listener ) == false )
            this.listeners$1.addItem( listener );
      },

   //------------------------------------------------------------------------------

      "public function removeListener",function removeListener( listener/* : TestListener*/ )/* : void*/
      {
         if ( this.listeners$1.contains( listener ) )
            this.listeners$1.removeItem( listener );
      },

   //------------------------------------------------------------------------------

      "public function runCount",function runCount()/* : Number*/
      {
         return this.runTests$1;
      },

   //------------------------------------------------------------------------------

      "private function doProtected",function doProtected( 
                  testCase/* : Test*/, 
                  protectable/* : Protectable*/ )/* : Boolean*/
      {
         var success/* : Boolean*/ = false;

         try
         {
            if(is( protectable,  flexunit.framework.ProtectedMiddleTestCase) )
            {
               flexunit.framework.Assert.resetAssertionsMade();
            }
            protectable.protect();
            success = true;
         }
         catch(error){if(is ( error , Error ))
         {
            if (is( error,  flexunit.framework.AssertionFailedError) )
            {
               this.addFailure( testCase,/* flexunit.framework.AssertionFailedError*/( error ) );
            }
            else
            {
               this.addError( testCase, error );
            }
         }else throw error;}
         
         if (is( protectable,  flexunit.framework.ProtectedMiddleTestCase) )
         {
            this._localAssertionsMade$1 = flexunit.framework.Assert.assetionsMade;            
         }
         
         return success;
      },

   //------------------------------------------------------------------------------

      "public function startTest",function startTest( test/* : Test*/ )/* : void*/
      {
         var count/* : Number*/ = test.countTestCases();
         this.runTests$1 = this.runTests$1 + count;

         var iter/* : Iterator*/ = this.listeners$1.iterator();
         var listener/* : TestListener*/;
         while ( iter.hasNext() )
         {
            listener =/* flexunit.framework.TestListener*/( iter.next() );
            listener.startTest( test );
         }
      },

   //------------------------------------------------------------------------------

      "public function endTest",function endTest( test/* : Test*/ )/* : void*/
      {
         var iter/* : Iterator*/ = this.listeners$1.iterator();
         var listener/* : TestListener*/;
         while ( iter.hasNext() )
         {
            listener =/* flexunit.framework.TestListener*/( iter.next() );
            listener.endTest( test );
         }
      },

   //------------------------------------------------------------------------------
   
      "public function get assertionsMade",function assertionsMade$get()/* : Number*/
      {
         return this._localAssertionsMade$1;
      },
      
      "private var",{ stopTests/* : Boolean*/:false},
      "private var",{ failures/* : Collection*/:null},
      "private var",{ errors/* : Collection*/:null},
      "private var",{ listeners/* : Collection*/:null},
      "private var",{ runTests/* : Number*/:NaN},
      "private var",{ _localAssertionsMade/* : Number*/:NaN},
   ];},[],["flexunit.utils.Collection","flexunit.utils.ArrayList","flexunit.framework.Protectable","flexunit.framework.ProtectedStartTestCase","flexunit.framework.ProtectedMiddleTestCase","flexunit.framework.ProtectedFinishTestCase","flexunit.framework.TestFailure","flexunit.framework.TestListener","flexunit.framework.Assert","Error","flexunit.framework.AssertionFailedError"], "0.8.0", "0.9.2"
);