/*

Copyright (c) 2008. Adobe Systems Incorporated.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

  * Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
  * Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.
  * Neither the name of Adobe Systems Incorporated nor the names of its
    contributors may be used to endorse or promote products derived from this
    software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

@ignore
*/

package flexunit.framework
{
   import flash.events.Event;

   import mx.collections.ArrayCollection;
   import mx.collections.ListCollectionView;

   /**
    * Listens for expected events, keeping track of the expected events that
    * actually occur. A helper class designed specifically for the
    * <code>EventfulTestCase</code>.
    */
   internal class EventfulTestCaseListener
   {

      /**
       * Gets a comma-separated string listing the types of events that were
       * expected.
       */
      public native function get expectedEventTypes() : String;

      /**
       * Gets a comma-separated string listing the types of events that were not
       * expected.
       */
      public native function get unexpectedEventTypes() : String;

      /**
       * Gets a comma-separated string listing the types of events that have
       * been heard.
       */
      public native function get dispatchedExpectedEventTypes() : String;

      /**
       * Gets an array of all the events that have been heard.
       */
      public native function get dispatchedExpectedEvents() : Array;

      /**
       * Gets the last event to have been heard.
       */
      public native function get lastDispatchedExpectedEvent() : Event;

      //-------------------------------
      //
      // constructor
      //
      //-------------------------------

      public function EventfulTestCaseListener(){super();}

      //-------------------------------
      //
      // functions
      //
      //-------------------------------

      /**
       * Records an event being listened for.
       *
       * @param type
       *    the type of event
       * @param expected
       *    whether the event is expected to be dispatched or not
       */
      public native function listenForEvent( type : String, expected : Boolean ) : void;

      /**
       * Verifies that the expected events were heard, returning
       * <code>true</code> if so or <code>false</code> otherwise.
       */
      public native function expectedEventsDispatched() : Boolean;

      /**
      *  Verifies the expected event was dispatched
      */
      public native function expectedEventDispatched( expectedEvent : String ) : Boolean;

      /**
       * Verifies that the unexpected events were not heard, returning
       * <code>true</code> if so or <code>false</code> otherwise.
       */
      public native function unexpectedEventsNotDispatched() : Boolean;

      /**
      *  Verifies that the unexpected event was not dispatched
      */
      public native function unexpectedEventNotDispatched( unexpectedEvent : String ) : Boolean;

      /**
       * Handles an event by recording that it actually occurred.
       */
      public native function handleEvent( event : Event ) : void;
   }
}