package net.jangaroo.joounit.runner {

import flexunit.framework.TestResult;

import flexunit.textui.XmlResultPrinter;

/**
 * TestRunner implementation for phantomjs.
 * <p>
 * The following example uses phantomjs-joo-runner.js to invoke
 * <code>PhantomJsRunner#main</code> launching
 * <code>flexunit.framework.AllFrameworkTests</code>
 * with 30 seconds timeout embedded in tests.html:
 * <code>
 *   phantomjs joo/phantomjs-joo-runner.js '{
 testSuiteName:"flexunit.framework.AllFrameworkTests",
 jooMainClass:"net.jangaroo.joounit.runner.PhantomJsRunner",
 timeout:30000,
 testsHtml:"tests.html"
 }'
 *   </code>
 * </p>
 */
public class PhantomJsRunner {

  static const config:Object;

  internal static native function error(e:Object);

  internal static native function getTestResultsFileName():String;

  internal static native function writeResult(testResult:*): void;

  internal static native function timedOut():void;

  public static native function main(testConfig:Object):void;

  internal static native function runTests() :void;

  internal static native function runTestsHtml(html:String);
}
}